/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.impl.keygenerator;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.dbrouter.config.DataSourceConfig;
import org.tinygroup.dbrouter.config.KeyTable;
import org.tinygroup.dbrouter.exception.DbrouterRuntimeException;
import org.tinygroup.dbrouter.util.DbRouterUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyTableInstallProcessor {
    private String tableName;
    private KeyTable keyTable;
    private DataSourceConfig dataSourceConfig;
    private static Logger logger = LoggerFactory.getLogger(KeyTableInstallProcessor.class);

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public KeyTable getKeyTable() {
        return this.keyTable;
    }

    public void setKeyTable(KeyTable keyTable) {
        this.keyTable = keyTable;
    }

    public DataSourceConfig getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    public void setDataSourceConfig(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }

    public int getOrder() {
        return 0;
    }

    public void process(String language) {
        Connection conn = null;
        try {
            conn = DbRouterUtil.createConnection(this.dataSourceConfig);
            if (!this.checkTableExist(language, conn)) {
                this.createkeyTable(conn);
                logger.logMessage(LogLevel.DEBUG, "\u521b\u5efa\u4e3b\u952e\u8868{0}\u6210\u529f.", new Object[]{this.tableName});
            } else {
                logger.logMessage(LogLevel.DEBUG, "\u4e3b\u952e\u8868{0}\u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u9700\u521b\u5efa.", new Object[]{this.tableName});
            }
        }
        catch (SQLException e) {
            throw new DbrouterRuntimeException(String.format("\u521b\u5efa\u4e3b\u952e\u8868%s\u53d1\u751f\u5f02\u5e38:", this.tableName), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkTableExist(String language, Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet resultset = null;
        try {
            resultset = meta.getTables(conn.getCatalog(), meta.getUserName(), this.tableName, new String[]{"TABLE"});
            boolean bl = resultset.next();
            return bl;
        }
        finally {
            if (resultset != null) {
                resultset.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createkeyTable(Connection conn) throws SQLException {
        Statement st = null;
        try {
            st = conn.createStatement();
            st.execute(this.keyTable.getRealSql(this.tableName));
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public List<String> getDealSqls(String language, Connection con) throws SQLException {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add(this.keyTable.getRealSql(this.tableName));
        return sqls;
    }
}

