/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.impl.keygenerator;

import java.util.UUID;
import org.tinygroup.dbrouter.RouterKeyGenerator;
import org.tinygroup.dbrouter.config.KeyTables;
import org.tinygroup.dbrouter.config.Router;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterKeyGeneratorUUID
implements RouterKeyGenerator<String> {
    @Override
    public String getKey(String tableName) {
        return RouterKeyGeneratorUUID.uuidToString(UUID.randomUUID());
    }

    private static String uuidToString(UUID uuid) {
        StringBuffer sb = new StringBuffer();
        sb.append(RouterKeyGeneratorUUID.digits(uuid.getMostSignificantBits() >> 32, 8));
        sb.append(RouterKeyGeneratorUUID.digits(uuid.getMostSignificantBits() >> 16, 4));
        sb.append(RouterKeyGeneratorUUID.digits(uuid.getMostSignificantBits(), 4));
        sb.append(RouterKeyGeneratorUUID.digits(uuid.getLeastSignificantBits() >> 48, 4));
        sb.append(RouterKeyGeneratorUUID.digits(uuid.getLeastSignificantBits(), 12));
        return sb.toString();
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    @Override
    public void setRouter(Router router) {
    }

    @Override
    public boolean isAutoCreate() {
        return false;
    }

    @Override
    public void createKeyTable(KeyTables keyTables) {
    }
}

