/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.impl.partionrule;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.List;
import org.tinygroup.dbrouter.PartitionRule;
import org.tinygroup.dbrouter.factory.RouterManagerBeanFactory;
import org.tinygroup.jsqlparser.schema.Table;
import org.tinygroup.jsqlparser.statement.Statement;
import org.tinygroup.jsqlparser.statement.delete.Delete;
import org.tinygroup.jsqlparser.statement.insert.Insert;
import org.tinygroup.jsqlparser.statement.select.FromItem;
import org.tinygroup.jsqlparser.statement.select.Join;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;
import org.tinygroup.jsqlparser.statement.select.Select;
import org.tinygroup.jsqlparser.statement.select.SelectBody;
import org.tinygroup.jsqlparser.statement.select.SetOperationList;
import org.tinygroup.jsqlparser.statement.select.SubSelect;
import org.tinygroup.jsqlparser.statement.select.WithItem;
import org.tinygroup.jsqlparser.statement.update.Update;

public class PartionRuleByTableName
implements PartitionRule {
    @XStreamAlias(value="table-name")
    @XStreamAsAttribute
    private String tableName;

    public PartionRuleByTableName() {
    }

    public PartionRuleByTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isMatch(String sql) {
        Update update;
        List tables;
        Insert insert;
        Delete delete;
        Statement statement = RouterManagerBeanFactory.getManager().getSqlStatement(sql);
        if (statement instanceof Delete && (delete = (Delete)statement).getTable().getName().equalsIgnoreCase(this.tableName)) {
            return true;
        }
        if (statement instanceof Insert && (insert = (Insert)statement).getTable().getName().equalsIgnoreCase(this.tableName)) {
            return true;
        }
        if (statement instanceof Update && (tables = (update = (Update)statement).getTables()) != null) {
            for (Table table : tables) {
                if (!table.getName().equalsIgnoreCase(this.tableName)) continue;
                return true;
            }
        }
        if (statement instanceof Select) {
            Select select = (Select)statement;
            SelectBody body = select.getSelectBody();
            if (body instanceof PlainSelect) {
                return this.plainSelectSqlMatch((PlainSelect)body);
            }
            if (body instanceof SetOperationList) {
                SetOperationList operationList = (SetOperationList)body;
                List plainSelects = operationList.getPlainSelects();
                for (PlainSelect plainSelect : plainSelects) {
                    if (!this.plainSelectSqlMatch(plainSelect)) continue;
                    return true;
                }
            }
            if (body instanceof WithItem) {
                WithItem withItem = (WithItem)body;
                PlainSelect plainSelect = (PlainSelect)withItem.getSelectBody();
                return this.plainSelectSqlMatch(plainSelect);
            }
        }
        return false;
    }

    private boolean plainSelectSqlMatch(PlainSelect plainSelect) {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            if (table.getName().equalsIgnoreCase(this.tableName)) {
                return true;
            }
            List joins = plainSelect.getJoins();
            if (joins != null) {
                for (Join join : joins) {
                    Table joinTable;
                    FromItem rightItem = join.getRightItem();
                    if (!(rightItem instanceof Table) || !(joinTable = (Table)rightItem).getName().equalsIgnoreCase(this.tableName)) continue;
                    return true;
                }
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            return this.plainSelectSqlMatch((PlainSelect)subSelect.getSelectBody());
        }
        return false;
    }
}

