/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.impl.shardrule;

import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.dbrouter.ShardRule;
import org.tinygroup.dbrouter.config.Partition;
import org.tinygroup.dbrouter.config.Shard;
import org.tinygroup.dbrouter.factory.RouterManagerBeanFactory;
import org.tinygroup.dbrouter.impl.shardrule.FieldWithValues;
import org.tinygroup.dbrouter.util.DbRouterUtil;
import org.tinygroup.jsqlparser.expression.DoubleValue;
import org.tinygroup.jsqlparser.expression.Expression;
import org.tinygroup.jsqlparser.expression.JdbcParameter;
import org.tinygroup.jsqlparser.expression.LongValue;
import org.tinygroup.jsqlparser.expression.StringValue;
import org.tinygroup.jsqlparser.expression.operators.conditional.AndExpression;
import org.tinygroup.jsqlparser.expression.operators.conditional.OrExpression;
import org.tinygroup.jsqlparser.expression.operators.relational.EqualsTo;
import org.tinygroup.jsqlparser.expression.operators.relational.ExpressionList;
import org.tinygroup.jsqlparser.expression.operators.relational.ItemsList;
import org.tinygroup.jsqlparser.schema.Column;
import org.tinygroup.jsqlparser.schema.Table;
import org.tinygroup.jsqlparser.statement.Statement;
import org.tinygroup.jsqlparser.statement.delete.Delete;
import org.tinygroup.jsqlparser.statement.insert.Insert;
import org.tinygroup.jsqlparser.statement.select.FromItem;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;
import org.tinygroup.jsqlparser.statement.select.Select;
import org.tinygroup.jsqlparser.statement.select.SelectBody;
import org.tinygroup.jsqlparser.statement.update.Update;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardRuleByFieldValue
implements ShardRule {
    @XStreamImplicit
    private List<FieldWithValues> fieldWithValues;

    @Override
    public boolean isMatch(Partition partition, Shard shard, String sql, Object ... preparedParams) {
        if (!CollectionUtil.isEmpty(this.fieldWithValues)) {
            Statement statement = RouterManagerBeanFactory.getManager().getSqlStatement(sql);
            AbstractFieldValueMatch fieldValueMatch = null;
            if (statement instanceof Insert) {
                Insert insert = (Insert)statement;
                fieldValueMatch = new InsertFieldValueMatch(this.fieldWithValues, insert, preparedParams);
            } else if (statement instanceof Delete) {
                Delete delete = (Delete)statement;
                fieldValueMatch = new DeleteFieldValueMatch(this.fieldWithValues, delete, preparedParams);
            } else if (statement instanceof Update) {
                Update update = (Update)statement;
                fieldValueMatch = new UpdateFieldValueMatch(this.fieldWithValues, update, preparedParams);
            } else if (statement instanceof Select) {
                Select select = (Select)statement;
                fieldValueMatch = new SelectFieldValueMatch(this.fieldWithValues, select, preparedParams);
            }
            if (fieldValueMatch == null) {
                return false;
            }
            return fieldValueMatch.isMatch();
        }
        return true;
    }

    @Override
    public String getReplacedSql(Partition partition, Shard shard, String sql) {
        return sql;
    }

    public List<FieldWithValues> getFieldWithValues() {
        if (this.fieldWithValues == null) {
            this.fieldWithValues = new ArrayList<FieldWithValues>();
        }
        return this.fieldWithValues;
    }

    public void setFieldWithValues(List<FieldWithValues> fieldWithValues) {
        this.fieldWithValues = fieldWithValues;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SelectFieldValueMatch
    extends AbstractFieldValueMatch {
        private Select select;

        public SelectFieldValueMatch(List<FieldWithValues> fields, Select select, Object ... preparedParams) {
            super(fields, preparedParams);
            this.select = select;
        }

        @Override
        public boolean isMatch() {
            Table table;
            PlainSelect plainSelect;
            FromItem fromItem;
            SelectBody body = this.select.getSelectBody();
            if (body instanceof PlainSelect && (fromItem = (plainSelect = (PlainSelect)body).getFromItem()) instanceof Table && this.tableName.equalsIgnoreCase((table = (Table)fromItem).getName())) {
                return this.getWhereExpression(plainSelect.getWhere());
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UpdateFieldValueMatch
    extends AbstractFieldValueMatch {
        private Update update;

        public UpdateFieldValueMatch(List<FieldWithValues> fields, Update update, Object ... preparedParams) {
            super(fields, preparedParams);
            this.update = update;
            List expressions = update.getExpressions();
            for (Expression expression : expressions) {
                if (!(expression instanceof JdbcParameter)) continue;
                ++this.paramIndex;
            }
        }

        @Override
        public boolean isMatch() {
            List tables = this.update.getTables();
            if (tables != null) {
                for (Table table : tables) {
                    if (!this.tableName.equalsIgnoreCase(table.getName())) continue;
                    Expression where = this.update.getWhere();
                    return this.getWhereExpression(where);
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DeleteFieldValueMatch
    extends AbstractFieldValueMatch {
        private Delete delete;

        public DeleteFieldValueMatch(List<FieldWithValues> fields, Delete delete, Object ... preparedParams) {
            super(fields, preparedParams);
            this.delete = delete;
        }

        @Override
        public boolean isMatch() {
            String deleteTableName = this.delete.getTable().getName();
            if (this.tableName.equalsIgnoreCase(deleteTableName)) {
                return this.getWhereExpression(this.delete.getWhere());
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InsertFieldValueMatch
    extends AbstractFieldValueMatch {
        private Insert insert;

        public InsertFieldValueMatch(List<FieldWithValues> fields, Insert insert, Object ... preparedParams) {
            super(fields, preparedParams);
            this.insert = insert;
        }

        @Override
        public boolean isMatch() {
            boolean match = false;
            if (this.tableName.equalsIgnoreCase(this.insert.getTable().getName())) {
                for (int i = 0; i < this.names.length; ++i) {
                    ItemsList itemsList;
                    int index = DbRouterUtil.checkColumnIndex(this.names[i], this.insert.getColumns());
                    Object[] params = this.fieldValues[i].split(",");
                    if (index != -1 && (itemsList = this.insert.getItemsList()) instanceof ExpressionList) {
                        List expressions = ((ExpressionList)itemsList).getExpressions();
                        Expression expression = (Expression)expressions.get(index - 1);
                        if (expression instanceof StringValue) {
                            StringValue stringValue = (StringValue)expression;
                            match = ArrayUtil.arrayContains((Object[])params, (Object)stringValue.getValue());
                        } else if (expression instanceof LongValue) {
                            LongValue longValue = (LongValue)expression;
                            match = ArrayUtil.arrayContains((Object[])params, (Object)longValue.getStringValue());
                        } else if (expression instanceof DoubleValue) {
                            DoubleValue doubleValue = (DoubleValue)expression;
                            match = ArrayUtil.arrayContains((Object[])params, (Object)doubleValue.toString());
                        } else if (expression instanceof JdbcParameter) {
                            int paramIndex = DbRouterUtil.checkParamIndex(index, expressions);
                            Object value = this.preparedParams[paramIndex];
                            match = ArrayUtil.arrayContains((Object[])params, (Object)value);
                        }
                    }
                    if (match) continue;
                    return false;
                }
            }
            return match;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractFieldValueMatch
    implements FieldValueMatch {
        protected int paramIndex = 0;
        protected List<FieldWithValues> fields;
        protected String[] names;
        protected String[] fieldValues;
        protected String tableName;
        protected Object[] preparedParams;

        public AbstractFieldValueMatch(List<FieldWithValues> fields, Object ... preparedParams) {
            this.fields = fields;
            this.names = new String[fields.size()];
            this.fieldValues = new String[fields.size()];
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i] = fields.get(i).getName();
                this.fieldValues[i] = fields.get(i).getValues();
            }
            this.tableName = fields.get(0).getTableName();
            this.preparedParams = preparedParams;
        }

        protected boolean getWhereExpression(Expression where) {
            if (where == null) {
                return true;
            }
            boolean equalsTo = this.getEqualsToExpression(where);
            if (where instanceof AndExpression) {
                AndExpression andExpression = (AndExpression)where;
                Expression leftExpression = andExpression.getLeftExpression();
                Expression rightExpression = andExpression.getRightExpression();
                boolean leftMatch = this.getWhereExpression(leftExpression);
                boolean rightMatch = this.getWhereExpression(rightExpression);
                return leftMatch && rightMatch;
            }
            if (where instanceof OrExpression) {
                OrExpression orExpression = (OrExpression)where;
                Expression leftExpression = orExpression.getLeftExpression();
                Expression rightExpression = orExpression.getRightExpression();
                boolean leftMatch = this.getWhereExpression(leftExpression);
                boolean rightMatch = this.getWhereExpression(rightExpression);
                return leftMatch || rightMatch;
            }
            return equalsTo;
        }

        private boolean getEqualsToExpression(Expression where) {
            boolean match = false;
            if (where instanceof EqualsTo) {
                EqualsTo equalsTo = (EqualsTo)where;
                Expression leftExpression = equalsTo.getLeftExpression();
                Expression rightExpression = equalsTo.getRightExpression();
                if (leftExpression instanceof Column) {
                    int indexInArray;
                    Column column = (Column)leftExpression;
                    String columnName = column.getColumnName();
                    int index = columnName.indexOf(46);
                    if (index != -1) {
                        columnName = columnName.substring(index + 1);
                    }
                    if ((indexInArray = ArrayUtil.arrayIndexOf((Object[])this.names, (Object)columnName)) != -1) {
                        Object[] params = this.fieldValues[indexInArray].split(",");
                        if (rightExpression instanceof StringValue) {
                            StringValue stringValue = (StringValue)rightExpression;
                            match = ArrayUtil.arrayContains((Object[])params, (Object)stringValue.getValue());
                        } else if (rightExpression instanceof LongValue) {
                            LongValue longValue = (LongValue)rightExpression;
                            match = ArrayUtil.arrayContains((Object[])params, (Object)longValue.getStringValue());
                        } else if (rightExpression instanceof DoubleValue) {
                            DoubleValue doubleValue = (DoubleValue)rightExpression;
                            match = ArrayUtil.arrayContains((Object[])params, (Object)doubleValue.toString());
                        } else if (rightExpression instanceof JdbcParameter) {
                            Object value = this.preparedParams[this.paramIndex];
                            match = ArrayUtil.arrayContains((Object[])params, (Object)value);
                            ++this.paramIndex;
                        }
                    } else {
                        if (rightExpression instanceof JdbcParameter) {
                            ++this.paramIndex;
                        }
                        match = true;
                    }
                }
            }
            return match;
        }

        public int getParamIndex() {
            return this.paramIndex;
        }
    }

    static interface FieldValueMatch {
        public boolean isMatch();
    }
}

