/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.impl.shardrule;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.tinygroup.cache.Cache;
import org.tinygroup.dbrouter.ShardRule;
import org.tinygroup.dbrouter.cache.CacheKey;
import org.tinygroup.dbrouter.config.Partition;
import org.tinygroup.dbrouter.config.Shard;
import org.tinygroup.dbrouter.factory.RouterManagerBeanFactory;
import org.tinygroup.dbrouter.impl.shardrule.ShardRuleMatchWithId;
import org.tinygroup.dbrouter.util.DbRouterUtil;
import org.tinygroup.jsqlparser.statement.Statement;
import org.tinygroup.jsqlparser.statement.delete.Delete;
import org.tinygroup.jsqlparser.statement.insert.Insert;
import org.tinygroup.jsqlparser.statement.select.Select;
import org.tinygroup.jsqlparser.statement.update.Update;

public abstract class ShardRuleByIdAbstract
implements ShardRule {
    @XStreamAsAttribute
    private long remainder;
    @XStreamAsAttribute
    @XStreamAlias(value="table-name")
    private String tableName;
    @XStreamAsAttribute
    @XStreamAlias(value="primary-key-field-name")
    private String primaryKeyFieldName;

    public ShardRuleByIdAbstract() {
    }

    public ShardRuleByIdAbstract(String tableName, String primaryKeyFieldName, int remainder) {
        this.tableName = tableName;
        this.primaryKeyFieldName = primaryKeyFieldName;
        this.remainder = remainder;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPrimaryKeyFieldName() {
        return this.primaryKeyFieldName;
    }

    public void setPrimaryKeyFieldName(String primaryKeyFieldName) {
        this.primaryKeyFieldName = primaryKeyFieldName;
    }

    public long getRemainder() {
        return this.remainder;
    }

    public void setRemainder(int remainder) {
        this.remainder = remainder;
    }

    public boolean isMatch(Partition partition, Shard shard, String sql, Object ... preparedParams) {
        Statement statement = RouterManagerBeanFactory.getManager().getSqlStatement(sql);
        if (DbRouterUtil.isSelect(statement)) {
            Cache cache = RouterManagerBeanFactory.getManager().getCache();
            CacheKey cacheKey = new CacheKey();
            cacheKey.update(this.tableName);
            cacheKey.update(this.primaryKeyFieldName);
            cacheKey.update(this.remainder);
            cacheKey.update(sql);
            for (Object param : preparedParams) {
                cacheKey.update(param);
            }
            Boolean match = null;
            try {
                match = (Boolean)cache.get(cacheKey.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (match == null) {
                match = this.shardRuleMatch(statement, partition, preparedParams);
                cache.put(cacheKey.toString(), (Object)match);
            }
            return match;
        }
        return this.shardRuleMatch(statement, partition, preparedParams);
    }

    private boolean shardRuleMatch(Statement statement, Partition partition, Object ... preparedParams) {
        ShardRuleMatchWithId matchWithId = new ShardRuleMatchWithId(this.remainder, this.tableName, this.primaryKeyFieldName, partition, preparedParams);
        if (statement instanceof Insert) {
            return matchWithId.insertMatch(statement);
        }
        if (statement instanceof Delete) {
            return matchWithId.deleteMatch(statement);
        }
        if (statement instanceof Update) {
            return matchWithId.updateMatch(statement);
        }
        if (statement instanceof Select) {
            return matchWithId.selectMatch(statement);
        }
        return false;
    }
}

