/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.impl.shardrule;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.tinygroup.cache.Cache;
import org.tinygroup.dbrouter.ShardRule;
import org.tinygroup.dbrouter.cache.CacheKey;
import org.tinygroup.dbrouter.config.Partition;
import org.tinygroup.dbrouter.config.Shard;
import org.tinygroup.dbrouter.exception.DbrouterRuntimeException;
import org.tinygroup.dbrouter.factory.RouterManagerBeanFactory;
import org.tinygroup.dbrouter.impl.shardrule.Section;
import org.tinygroup.dbrouter.impl.shardrule.ShardRuleMatchWithSectionAndHash;
import org.tinygroup.dbrouter.util.ConsistentHash;
import org.tinygroup.dbrouter.util.DbRouterUtil;
import org.tinygroup.jsqlparser.statement.Statement;
import org.tinygroup.jsqlparser.statement.delete.Delete;
import org.tinygroup.jsqlparser.statement.insert.Insert;
import org.tinygroup.jsqlparser.statement.select.Select;
import org.tinygroup.jsqlparser.statement.update.Update;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardRuleBySectionAndHashDifferentSchema
implements ShardRule {
    @XStreamAsAttribute
    @XStreamAlias(value="table-name")
    private String tableName;
    @XStreamAsAttribute
    @XStreamAlias(value="field-Name")
    private String fieldName;
    @XStreamAsAttribute
    private String expression;
    @XStreamAlias(value="sections")
    private List<Section> sections = new ArrayList<Section>();
    private Section[] sectionArray;
    private String targetTableName;
    @XStreamAsAttribute
    @XStreamAlias(value="table-param")
    private String tableParam;
    private transient ConsistentHash<String> consistentHash;

    private void sort(List<Section> sections) {
        if (null == this.sectionArray) {
            Collections.sort(sections, new SectionComparator());
            this.sectionArray = sections.toArray(new Section[0]);
        }
    }

    @Override
    public boolean isMatch(Partition partition, Shard shard, String sql, Object ... preparedParams) {
        this.sort(this.sections);
        this.inittargetTable(shard);
        this.initHash();
        Statement statement = RouterManagerBeanFactory.getManager().getSqlStatement(sql);
        if (DbRouterUtil.isSelect(statement)) {
            Cache cache = RouterManagerBeanFactory.getManager().getCache();
            CacheKey cacheKey = new CacheKey();
            cacheKey.update(this.fieldName);
            cacheKey.update(this.tableName);
            cacheKey.update(this.targetTableName);
            cacheKey.update(this.sectionArray);
            cacheKey.update(sql);
            for (Object param : preparedParams) {
                cacheKey.update(param);
            }
            Boolean match = null;
            try {
                match = (Boolean)cache.get(cacheKey.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (match == null) {
                match = this.shardRuleMatch(statement, partition, preparedParams);
                cache.put(cacheKey.toString(), (Object)match);
            }
            return match;
        }
        return this.shardRuleMatch(statement, partition, preparedParams);
    }

    private void inittargetTable(Shard shard) {
        Map<String, String> tableMapping = shard.getTableMappingMap();
        if (null == this.targetTableName && null != tableMapping) {
            this.targetTableName = tableMapping.get(this.tableName);
            this.targetTableName = null == this.targetTableName || "".equals(this.targetTableName.trim()) ? this.tableName : this.targetTableName;
        } else if (null == this.targetTableName || "".equals(this.targetTableName.trim())) {
            this.targetTableName = this.tableName;
        }
    }

    private boolean shardRuleMatch(Statement statement, Partition partition, Object ... preparedParams) {
        ShardRuleMatchWithSectionAndHash matchWithId = new ShardRuleMatchWithSectionAndHash(this.sections, this.tableName, this.targetTableName, this.consistentHash, this.fieldName, this.expression, partition, preparedParams);
        if (statement instanceof Insert) {
            return matchWithId.insertMatch(statement);
        }
        if (statement instanceof Delete) {
            return matchWithId.deleteMatch(statement);
        }
        if (statement instanceof Update) {
            return matchWithId.updateMatch(statement);
        }
        if (statement instanceof Select) {
            return matchWithId.selectMatch(statement);
        }
        return false;
    }

    private void initHash() {
        if (null == this.consistentHash) {
            ArrayList<String> nodes = new ArrayList<String>();
            if (null != this.tableParam && !"".equals(this.tableParam.trim())) {
                String[] params = this.tableParam.split(",");
                int tableIndex = Integer.parseInt(params[0]);
                for (int i = 0; i < Integer.parseInt(params[1]); ++i) {
                    nodes.add(this.tableName + tableIndex);
                    ++tableIndex;
                }
            } else if (null != this.targetTableName && !"".equals(this.targetTableName.trim())) {
                nodes.add(this.targetTableName);
            } else {
                nodes.add(this.tableName);
            }
            if (!nodes.contains(this.targetTableName)) {
                throw new DbrouterRuntimeException("ShardRule[" + this.toString() + "] error");
            }
            this.consistentHash = new ConsistentHash(nodes);
        }
    }

    @Override
    public String getReplacedSql(Partition partition, Shard shard, String sql) {
        if (null != shard.getTableMappingMap()) {
            return DbRouterUtil.transformSqlWithTableName(sql, shard.getTableMappingMap());
        }
        return sql;
    }

    public String toString() {
        return "ShardRuleBySectionAndHashDifferentSchema [tableName=" + this.tableName + ", fieldName=" + this.fieldName + ", expression=" + this.expression + ", sections=" + this.sections + ", targetTableName=" + this.targetTableName + ", tableParam=" + this.tableParam + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SectionComparator
    implements Comparator<Section> {
        SectionComparator() {
        }

        @Override
        public int compare(Section o1, Section o2) {
            return o1.getStart() == o2.getStart() ? 0 : (o1.getStart() < o2.getStart() ? -1 : 1);
        }
    }
}

