/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.impl.shardrule;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.cache.Cache;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.dbrouter.ShardRule;
import org.tinygroup.dbrouter.cache.CacheKey;
import org.tinygroup.dbrouter.config.Partition;
import org.tinygroup.dbrouter.config.Shard;
import org.tinygroup.dbrouter.config.TableMapping;
import org.tinygroup.dbrouter.factory.RouterManagerBeanFactory;
import org.tinygroup.dbrouter.impl.shardrule.Section;
import org.tinygroup.dbrouter.impl.shardrule.ShardRuleMatchWithSections;
import org.tinygroup.dbrouter.util.DbRouterUtil;
import org.tinygroup.jsqlparser.statement.Statement;
import org.tinygroup.jsqlparser.statement.delete.Delete;
import org.tinygroup.jsqlparser.statement.insert.Insert;
import org.tinygroup.jsqlparser.statement.select.Select;
import org.tinygroup.jsqlparser.statement.update.Update;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardRuleBySectionDifferentSchema
implements ShardRule {
    @XStreamAsAttribute
    @XStreamAlias(value="table-name")
    private String tableName;
    @XStreamAsAttribute
    @XStreamAlias(value="field-Name")
    private String fieldName;
    @XStreamAlias(value="sections")
    private List<Section> sections = new ArrayList<Section>();
    private Section[] sectionArray;
    @XStreamAlias(value="table-mappings")
    private List<TableMapping> tableMappings;
    private transient Map<String, String> tableMappingMap = null;

    private void sort(List<Section> sections) {
        if (null == this.sectionArray) {
            Collections.sort(sections, new SectionComparator());
            this.sectionArray = sections.toArray(new Section[0]);
        }
    }

    @Override
    public boolean isMatch(Partition partition, Shard shard, String sql, Object ... preparedParams) {
        this.sort(this.sections);
        Statement statement = RouterManagerBeanFactory.getManager().getSqlStatement(sql);
        if (DbRouterUtil.isSelect(statement)) {
            Cache cache = RouterManagerBeanFactory.getManager().getCache();
            CacheKey cacheKey = new CacheKey();
            cacheKey.update(this.tableName);
            cacheKey.update(this.fieldName);
            cacheKey.update(this.sectionArray);
            cacheKey.update(sql);
            for (Object param : preparedParams) {
                cacheKey.update(param);
            }
            Boolean match = null;
            try {
                match = (Boolean)cache.get(cacheKey.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (match == null) {
                match = this.shardRuleMatch(statement, partition, preparedParams);
                cache.put(cacheKey.toString(), (Object)match);
            }
            return match;
        }
        return this.shardRuleMatch(statement, partition, preparedParams);
    }

    private boolean shardRuleMatch(Statement statement, Partition partition, Object ... preparedParams) {
        ShardRuleMatchWithSections matchWithId = new ShardRuleMatchWithSections(this.sections, this.tableName, this.fieldName, partition, preparedParams);
        if (statement instanceof Insert) {
            return matchWithId.insertMatch(statement);
        }
        if (statement instanceof Delete) {
            return matchWithId.deleteMatch(statement);
        }
        if (statement instanceof Update) {
            return matchWithId.updateMatch(statement);
        }
        if (statement instanceof Select) {
            return matchWithId.selectMatch(statement);
        }
        return false;
    }

    @Override
    public String getReplacedSql(Partition partition, Shard shard, String sql) {
        if (!CollectionUtil.isEmpty(this.getTableMappings())) {
            return DbRouterUtil.transformSqlWithTableName(sql, this.getTableMappingMap());
        }
        return sql;
    }

    public Map<String, String> getTableMappingMap() {
        if (this.tableMappings != null && this.tableMappingMap == null) {
            this.tableMappingMap = new HashMap<String, String>();
            for (TableMapping mapping : this.tableMappings) {
                this.tableMappingMap.put(mapping.getTableName(), mapping.getShardTableName());
            }
        }
        return this.tableMappingMap;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<TableMapping> getTableMappings() {
        return this.tableMappings;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SectionComparator
    implements Comparator<Section> {
        SectionComparator() {
        }

        @Override
        public int compare(Section o1, Section o2) {
            return o1.getStart() == o2.getStart() ? 0 : (o1.getStart() < o2.getStart() ? -1 : 1);
        }
    }
}

