/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.impl.shardrule;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.tinygroup.dbrouter.config.Partition;
import org.tinygroup.dbrouter.impl.shardrule.Section;
import org.tinygroup.dbrouter.util.ConsistentHash;
import org.tinygroup.jsqlparser.expression.Expression;
import org.tinygroup.jsqlparser.expression.JdbcParameter;
import org.tinygroup.jsqlparser.expression.LongValue;
import org.tinygroup.jsqlparser.expression.operators.relational.EqualsTo;
import org.tinygroup.jsqlparser.expression.operators.relational.ExpressionList;
import org.tinygroup.jsqlparser.expression.operators.relational.ItemsList;
import org.tinygroup.jsqlparser.schema.Column;
import org.tinygroup.jsqlparser.schema.Table;
import org.tinygroup.jsqlparser.statement.Statement;
import org.tinygroup.jsqlparser.statement.delete.Delete;
import org.tinygroup.jsqlparser.statement.insert.Insert;
import org.tinygroup.jsqlparser.statement.select.FromItem;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;
import org.tinygroup.jsqlparser.statement.select.Select;
import org.tinygroup.jsqlparser.statement.select.SelectBody;
import org.tinygroup.jsqlparser.statement.update.Update;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardRuleMatchWithSectionAndHash {
    private List<Section> sections;
    private String tableName;
    private String fieldName;
    private Partition partition;
    private Object[] preparedParams;
    private String targetTableName;
    private ConsistentHash<String> consistentHash;
    private Class<?> scriptClazz;
    private String expression;
    private static final ConcurrentHashMap<String, Class<?>> scriptClazzMap = new ConcurrentHashMap();

    public ShardRuleMatchWithSectionAndHash(List<Section> sections, String tableName, String targetTableName, ConsistentHash<String> consistentHash, String fieldName, String expression, Partition partition, Object[] preparedParams) {
        this.sections = sections;
        this.tableName = tableName;
        this.fieldName = fieldName;
        this.partition = partition;
        this.preparedParams = preparedParams;
        this.targetTableName = null == targetTableName || "".equals(targetTableName.trim()) ? tableName : targetTableName;
        this.consistentHash = consistentHash;
        this.expression = expression;
        if (null != expression && !"".equals(expression.trim())) {
            this.scriptClazz = scriptClazzMap.get(expression);
            if (null == this.scriptClazz) {
                GroovyClassLoader loader = new GroovyClassLoader();
                this.scriptClazz = loader.parseClass(expression);
                scriptClazzMap.putIfAbsent(expression, this.scriptClazz);
            }
        }
    }

    public boolean insertMatch(Statement statement) {
        ItemsList itemsList;
        Insert insert = (Insert)statement;
        int paramIndex = 0;
        if (this.tableName.equalsIgnoreCase(insert.getTable().getName()) && (itemsList = insert.getItemsList()) instanceof ExpressionList) {
            List expressions = ((ExpressionList)itemsList).getExpressions();
            for (int i = 0; i < insert.getColumns().size(); ++i) {
                long value;
                LongValue longValue;
                long value2;
                Column column = (Column)insert.getColumns().get(i);
                Expression expression = (Expression)expressions.get(i);
                if (column.getColumnName().equalsIgnoreCase(this.fieldName) && (expression instanceof LongValue ? this.isInScope(this.sections, value2 = this.dealExpression((longValue = (LongValue)expression).getStringValue())) && this.consistentHash.getShardInfo(String.valueOf(value2)).equals(this.targetTableName) : expression instanceof JdbcParameter && this.isInScope(this.sections, value = this.dealExpression(this.preparedParams[paramIndex].toString())) && this.consistentHash.getShardInfo(String.valueOf(value)).equals(this.targetTableName))) {
                    return true;
                }
                if (!(expression instanceof JdbcParameter)) continue;
                ++paramIndex;
            }
        }
        return false;
    }

    public boolean updateMatch(Statement statement) {
        Update update = (Update)statement;
        List expressions = update.getExpressions();
        int paramIndex = 0;
        for (Expression expression : expressions) {
            if (!(expression instanceof JdbcParameter)) continue;
            ++paramIndex;
        }
        List tables = update.getTables();
        if (tables != null) {
            for (Table table : tables) {
                if (!this.tableName.equalsIgnoreCase(table.getName())) continue;
                return this.getWhereExpression(paramIndex, update.getWhere(), this.partition, this.preparedParams);
            }
        }
        return false;
    }

    public boolean deleteMatch(Statement statement) {
        Delete delete = (Delete)statement;
        if (this.tableName.equalsIgnoreCase(delete.getTable().getName())) {
            return this.getWhereExpression(0, delete.getWhere(), this.partition, this.preparedParams);
        }
        return false;
    }

    public boolean selectMatch(Statement statement) {
        Table table;
        PlainSelect plainSelect;
        FromItem fromItem;
        Select select = (Select)statement;
        SelectBody body = select.getSelectBody();
        if (body instanceof PlainSelect && (fromItem = (plainSelect = (PlainSelect)body).getFromItem()) instanceof Table && this.tableName.equalsIgnoreCase((table = (Table)fromItem).getName())) {
            return this.getWhereExpression(0, plainSelect.getWhere(), this.partition, this.preparedParams);
        }
        return false;
    }

    private boolean getWhereExpression(int paramIndex, Expression where, Partition partition, Object ... preparedParams) {
        if (where == null) {
            return true;
        }
        return this.getEqualsToExpression(paramIndex, where, partition, preparedParams);
    }

    private boolean getEqualsToExpression(int paramIndex, Expression where, Partition partition, Object ... preparedParams) {
        if (where instanceof EqualsTo) {
            long value;
            LongValue longValue;
            long value2;
            Column column;
            EqualsTo equalsTo = (EqualsTo)where;
            Expression leftExpression = equalsTo.getLeftExpression();
            Expression rightExpression = equalsTo.getRightExpression();
            if (leftExpression instanceof Column && (column = (Column)leftExpression).getColumnName().equalsIgnoreCase(this.fieldName) && (rightExpression instanceof LongValue ? this.isInScope(this.sections, value2 = this.dealExpression((longValue = (LongValue)rightExpression).getStringValue())) && this.consistentHash.getShardInfo(String.valueOf(value2)).equals(this.targetTableName) : rightExpression instanceof JdbcParameter && this.isInScope(this.sections, value = this.dealExpression(preparedParams[paramIndex].toString())) && this.consistentHash.getShardInfo(String.valueOf(value)).equals(this.targetTableName))) {
                return true;
            }
        }
        return false;
    }

    private long dealExpression(String value) {
        if (null != this.scriptClazz) {
            Binding binding = new Binding();
            binding.setVariable("value", (Object)value);
            Script script = null;
            try {
                script = (Script)this.scriptClazz.newInstance();
            }
            catch (Exception e) {
                GroovyShell shell = new GroovyShell();
                script = shell.parse(this.expression);
            }
            script.setBinding(binding);
            return (Long)script.run();
        }
        return Long.parseLong(value);
    }

    private boolean isInScope(List<Section> sections, long value) {
        for (Section section : sections) {
            if (section.getStart() > value) {
                return false;
            }
            if (!this.isInScope(section, value)) continue;
            return true;
        }
        return false;
    }

    private boolean isInScope(Section section, long value) {
        return section.getStart() <= value && value <= section.getEnd();
    }
}

