/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsistentHash<T> {
    private final int numberOfReplicas;
    private final SortedMap<Long, T> circle = new TreeMap<Long, T>();

    public ConsistentHash(Collection<T> nodes) {
        this(100, nodes);
    }

    public ConsistentHash(int numberOfReplicas, Collection<T> nodes) {
        this.numberOfReplicas = numberOfReplicas;
        for (T node : nodes) {
            this.addShardInfo(node);
        }
    }

    public void addShardInfo(T node) {
        for (int i = 0; i < this.numberOfReplicas; ++i) {
            this.circle.put(this.hash(node.toString() + i), node);
        }
    }

    public List<Long> getShard(T node) {
        ArrayList<Long> datas = new ArrayList<Long>();
        for (Map.Entry<Long, T> entry : this.circle.entrySet()) {
            if (!entry.getValue().equals(node)) continue;
            datas.add(entry.getKey());
        }
        return datas;
    }

    public void removeShardInfo(T node) {
        for (int i = 0; i < this.numberOfReplicas; ++i) {
            this.circle.remove(this.hash(node.toString() + i));
        }
    }

    public T getShardInfo(String key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        long hash = this.hash(key);
        if (!this.circle.containsKey(hash)) {
            SortedMap<Long, T> tailMap = this.circle.tailMap(hash);
            hash = tailMap.isEmpty() ? this.circle.firstKey() : tailMap.firstKey();
        }
        return (T)this.circle.get(hash);
    }

    public Long hash(String key) {
        ByteBuffer buf = ByteBuffer.wrap(key.getBytes());
        int seed = 305441741;
        ByteOrder byteOrder = buf.order();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long m = -4132994306676758123L;
        int r = 47;
        long h = (long)seed ^ (long)buf.remaining() * m;
        while (buf.remaining() >= 8) {
            long k = buf.getLong();
            k *= m;
            k ^= k >>> r;
            h ^= (k *= m);
            h *= m;
        }
        if (buf.remaining() > 0) {
            ByteBuffer finish = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            finish.put(buf).rewind();
            h ^= finish.getLong();
            h *= m;
        }
        h ^= h >>> r;
        h *= m;
        h ^= h >>> r;
        buf.order(byteOrder);
        return h;
    }

    public static String getRandomString(int length) {
        StringBuffer buffer = new StringBuffer("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        int range = buffer.length();
        for (int i = 0; i < length; ++i) {
            sb.append(buffer.charAt(random.nextInt(range)));
        }
        return sb.toString();
    }
}

