/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.dbrouter.config.DataSourceConfig;
import org.tinygroup.dbrouter.config.Router;
import org.tinygroup.dbrouter.exception.DbrouterRuntimeException;
import org.tinygroup.dbrouter.factory.RouterManagerBeanFactory;
import org.tinygroup.jsqlparser.expression.Alias;
import org.tinygroup.jsqlparser.expression.BinaryExpression;
import org.tinygroup.jsqlparser.expression.Expression;
import org.tinygroup.jsqlparser.expression.Function;
import org.tinygroup.jsqlparser.expression.JdbcParameter;
import org.tinygroup.jsqlparser.expression.LongValue;
import org.tinygroup.jsqlparser.expression.StringValue;
import org.tinygroup.jsqlparser.expression.operators.conditional.AndExpression;
import org.tinygroup.jsqlparser.expression.operators.conditional.OrExpression;
import org.tinygroup.jsqlparser.expression.operators.relational.ExistsExpression;
import org.tinygroup.jsqlparser.expression.operators.relational.ExpressionList;
import org.tinygroup.jsqlparser.expression.operators.relational.InExpression;
import org.tinygroup.jsqlparser.expression.operators.relational.ItemsList;
import org.tinygroup.jsqlparser.schema.Column;
import org.tinygroup.jsqlparser.schema.Table;
import org.tinygroup.jsqlparser.statement.Statement;
import org.tinygroup.jsqlparser.statement.delete.Delete;
import org.tinygroup.jsqlparser.statement.insert.Insert;
import org.tinygroup.jsqlparser.statement.select.AllColumns;
import org.tinygroup.jsqlparser.statement.select.AllTableColumns;
import org.tinygroup.jsqlparser.statement.select.FromItem;
import org.tinygroup.jsqlparser.statement.select.Join;
import org.tinygroup.jsqlparser.statement.select.OrderByElement;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;
import org.tinygroup.jsqlparser.statement.select.Select;
import org.tinygroup.jsqlparser.statement.select.SelectBody;
import org.tinygroup.jsqlparser.statement.select.SelectExpressionItem;
import org.tinygroup.jsqlparser.statement.select.SelectItem;
import org.tinygroup.jsqlparser.statement.select.SetOperationList;
import org.tinygroup.jsqlparser.statement.select.SubJoin;
import org.tinygroup.jsqlparser.statement.select.SubSelect;
import org.tinygroup.jsqlparser.statement.select.WithItem;
import org.tinygroup.jsqlparser.statement.update.Update;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DbRouterUtil {
    private static final Pattern JDBC_PATTERN = Pattern.compile("jdbc:.*:.*", 2);
    private static Map<String, String> JDBC_CHANGE_MAP = new HashMap<String, String>();

    private DbRouterUtil() {
    }

    public static String transformSqlWithTableName(String sql, Map<String, String> tableMapping) {
        try {
            Statement originalStatement = RouterManagerBeanFactory.getManager().getSqlStatement(sql);
            Statement statement = (Statement)DbRouterUtil.deepCopy(originalStatement);
            if (statement instanceof Insert) {
                return DbRouterUtil.transformInsertSql(tableMapping, statement);
            }
            if (statement instanceof Delete) {
                return DbRouterUtil.transformDeleteSql(tableMapping, statement);
            }
            if (statement instanceof Update) {
                return DbRouterUtil.transformUpdateSql(tableMapping, statement);
            }
            if (statement instanceof Select) {
                return DbRouterUtil.transformSelectSql(tableMapping, statement);
            }
            return sql;
        }
        catch (Exception e) {
            throw new DbrouterRuntimeException(e);
        }
    }

    private static String transformSelectSql(Map<String, String> tableMapping, Statement statement) {
        Select select = (Select)statement;
        SelectBody body = select.getSelectBody();
        DbRouterUtil.transformSelectBody(body, tableMapping);
        return select.toString();
    }

    private static String transformUpdateSql(Map<String, String> tableMapping, Statement statement) {
        Update update = (Update)statement;
        List tables = update.getTables();
        if (tables != null) {
            for (Table table : tables) {
                String tableName = table.getName();
                String newTableName = tableMapping.get(tableName);
                if (StringUtil.isBlank((String)newTableName)) continue;
                table.setName(newTableName);
            }
        }
        Expression expression = update.getWhere();
        DbRouterUtil.transformExpression(expression, tableMapping);
        return update.toString();
    }

    private static String transformDeleteSql(Map<String, String> tableMapping, Statement statement) {
        Delete delete = (Delete)statement;
        String tableName = delete.getTable().getName();
        String newTableName = tableMapping.get(tableName);
        if (!StringUtil.isBlank((String)newTableName)) {
            delete.getTable().setName(newTableName);
        }
        Expression expression = delete.getWhere();
        DbRouterUtil.transformExpression(expression, tableMapping);
        return delete.toString();
    }

    private static String transformInsertSql(Map<String, String> tableMapping, Statement statement) {
        Insert insert = (Insert)statement;
        String tableName = insert.getTable().getName();
        String newTableName = tableMapping.get(tableName);
        if (!StringUtil.isBlank((String)newTableName)) {
            insert.getTable().setName(newTableName);
            List columns = insert.getColumns();
            for (Column column : columns) {
                Table columnTable = column.getTable();
                if (columnTable == null || StringUtil.isBlank((String)columnTable.getName())) continue;
                columnTable.setName(newTableName);
            }
        }
        return insert.toString();
    }

    private static void transformExpression(Expression expression, Map<String, String> tableMapping) {
        if (expression == null) {
            return;
        }
        if (expression instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)expression;
            DbRouterUtil.transformSubSelect(subSelect, tableMapping);
        } else if (expression instanceof AndExpression) {
            AndExpression andExpression = (AndExpression)expression;
            Expression rightExpression = andExpression.getRightExpression();
            DbRouterUtil.transformExpression(rightExpression, tableMapping);
        } else if (expression instanceof OrExpression) {
            OrExpression orExpression = (OrExpression)expression;
            Expression rightExpression = orExpression.getRightExpression();
            DbRouterUtil.transformExpression(rightExpression, tableMapping);
        } else if (expression instanceof InExpression) {
            InExpression inExpression = (InExpression)expression;
            ItemsList rightItemsList = inExpression.getRightItemsList();
            if (rightItemsList instanceof SubSelect) {
                SubSelect subSelect = (SubSelect)rightItemsList;
                DbRouterUtil.transformSubSelect(subSelect, tableMapping);
            }
        } else if (expression instanceof ExistsExpression) {
            ExistsExpression existsExpression = (ExistsExpression)expression;
            DbRouterUtil.transformExpression(existsExpression.getRightExpression(), tableMapping);
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            DbRouterUtil.transformExpression(binaryExpression.getRightExpression(), tableMapping);
        }
    }

    private static void transformSubSelect(SubSelect select, Map<String, String> tableMapping) {
        SelectBody body = select.getSelectBody();
        DbRouterUtil.transformSelectBody(body, tableMapping);
    }

    private static void transformSelectBody(SelectBody body, Map<String, String> tableMapping) {
        if (body instanceof PlainSelect) {
            DbRouterUtil.transfromPlainSelect((PlainSelect)body, tableMapping);
        }
        if (body instanceof SetOperationList) {
            SetOperationList operationList = (SetOperationList)body;
            List plainSelects = operationList.getPlainSelects();
            for (PlainSelect plainSelect : plainSelects) {
                DbRouterUtil.transfromPlainSelect(plainSelect, tableMapping);
            }
        }
        if (body instanceof WithItem) {
            WithItem withItem = (WithItem)body;
            SelectBody selectBody = withItem.getSelectBody();
            DbRouterUtil.transformSelectBody(selectBody, tableMapping);
        }
    }

    private static void transfromPlainSelect(PlainSelect plainSelect, Map<String, String> tableMapping) {
        Expression where;
        List joins;
        DbRouterUtil.checkOrderByAndGroupbyItem(plainSelect);
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem != null) {
            DbRouterUtil.transfromFromItem(fromItem, tableMapping);
        }
        if (!CollectionUtil.isEmpty((Collection)(joins = plainSelect.getJoins()))) {
            for (Join join : joins) {
                FromItem rightItem = join.getRightItem();
                DbRouterUtil.transfromFromItem(rightItem, tableMapping);
            }
        }
        if ((where = plainSelect.getWhere()) != null) {
            DbRouterUtil.transformExpression(where, tableMapping);
        }
    }

    private static void transfromFromItem(FromItem fromItem, Map<String, String> tableMapping) {
        if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            String tableName = table.getName();
            String newTableName = tableMapping.get(tableName);
            if (!StringUtil.isBlank((String)newTableName)) {
                table.setName(newTableName);
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            DbRouterUtil.transformSubSelect(subSelect, tableMapping);
        } else if (fromItem instanceof SubJoin) {
            SubJoin join = (SubJoin)fromItem;
            FromItem left = join.getLeft();
            DbRouterUtil.transfromFromItem(left, tableMapping);
            Join right = join.getJoin();
            DbRouterUtil.transfromFromItem(right.getRightItem(), tableMapping);
        }
    }

    public static int getSqlParamSize(String sql) {
        int paramSize = 0;
        int len = sql.length() + 1;
        char[] command = new char[len];
        sql.getChars(0, --len, command, 0);
        for (int i = 0; i < len; ++i) {
            char c = command[i];
            if (c != '?') continue;
            ++paramSize;
        }
        return paramSize;
    }

    private static String getRealTableName(Map<String, String> tableMapping, String tableName) {
        String realTableName = tableName;
        if (tableMapping != null && tableMapping.containsKey(tableName)) {
            realTableName = tableMapping.get(tableName);
        }
        return realTableName;
    }

    private static void addPrimaryKeyExpression(Router router, String tableName, int dataType, ItemsList itemsList) {
        List expressions = ((ExpressionList)itemsList).getExpressions();
        StringValue expression = null;
        switch (dataType) {
            case -1: 
            case 1: 
            case 12: {
                StringValue stringValue;
                String value = (String)RouterManagerBeanFactory.getManager().getPrimaryKey(router, tableName);
                expression = stringValue = new StringValue(value);
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                Object values = RouterManagerBeanFactory.getManager().getPrimaryKey(router, tableName);
                expression = new LongValue(values + "");
                break;
            }
        }
        expressions.add(expression);
    }

    public static void checkOrderByAndGroupbyItem(PlainSelect plainSelect) {
        List<Column> groupByColumns = DbRouterUtil.getGroupByColumns(plainSelect);
        List selectItems = plainSelect.getSelectItems();
        for (Column groupByColumn : groupByColumns) {
            DbRouterUtil.checkItem(selectItems, groupByColumn);
        }
    }

    public static void checkItem(List<SelectItem> selectItems, Column checkColumn) {
        String columnName = checkColumn.getFullyQualifiedName();
        boolean isExist = false;
        for (SelectItem selectItem : selectItems) {
            if (selectItem instanceof AllColumns) {
                isExist = true;
                break;
            }
            if (selectItem instanceof AllTableColumns) {
                isExist = true;
                break;
            }
            SelectExpressionItem item = (SelectExpressionItem)selectItem;
            Alias alias = item.getAlias();
            if (alias != null && columnName.equals(alias.getName())) {
                isExist = true;
                break;
            }
            Expression expression = item.getExpression();
            if (expression instanceof Column) {
                Column column = (Column)expression;
                if (!columnName.equals(column.getFullyQualifiedName()) && !columnName.equals(column.getColumnName())) continue;
                isExist = true;
                break;
            }
            if (!(expression instanceof Function)) continue;
        }
        if (!isExist) {
            SelectExpressionItem item = new SelectExpressionItem();
            Column column = new Column(checkColumn.getTable(), checkColumn.getColumnName());
            item.setExpression((Expression)column);
            selectItems.add((SelectItem)item);
        }
    }

    public static int[] getOrderByIndexs(PlainSelect plainSelect, ResultSet resultSet) throws SQLException {
        List<Column> orderByColumns = DbRouterUtil.getOrderByColumns(plainSelect);
        if (CollectionUtil.isEmpty(orderByColumns)) {
            return new int[0];
        }
        List selectItems = plainSelect.getSelectItems();
        int[] indexs = new int[orderByColumns.size()];
        block0: for (int i = 0; i < orderByColumns.size(); ++i) {
            Column orderByColumn = orderByColumns.get(i);
            String orderByName = orderByColumn.getFullyQualifiedName();
            for (int j = 0; j < selectItems.size(); ++j) {
                Column column;
                SelectItem selectItem = (SelectItem)selectItems.get(j);
                if (selectItem instanceof AllColumns || selectItem instanceof AllTableColumns) {
                    indexs[i] = resultSet.findColumn(orderByName) - 1;
                    continue block0;
                }
                SelectExpressionItem item = (SelectExpressionItem)selectItem;
                Alias alias = item.getAlias();
                if (alias != null && orderByName.equals(alias.getName())) {
                    indexs[i] = j;
                    continue block0;
                }
                Expression expression = item.getExpression();
                if (!(expression instanceof Column) || !orderByName.equals((column = (Column)expression).getFullyQualifiedName()) && !orderByName.equals(column.getColumnName())) continue;
                indexs[i] = j;
            }
        }
        return indexs;
    }

    public static List<Column> getOrderByColumns(PlainSelect plainSelect) {
        ArrayList<Column> orderByColumns = new ArrayList<Column>();
        List orderByElements = plainSelect.getOrderByElements();
        if (!CollectionUtil.isEmpty((Collection)orderByElements)) {
            for (OrderByElement orderByElement : orderByElements) {
                Column column = (Column)orderByElement.getExpression();
                orderByColumns.add(column);
            }
        }
        return orderByColumns;
    }

    public static List<Column> getGroupByColumns(PlainSelect plainSelect) {
        ArrayList<Column> groupByColumns = new ArrayList<Column>();
        List groupExpressions = plainSelect.getGroupByColumnReferences();
        if (!CollectionUtil.isEmpty((Collection)groupExpressions)) {
            for (Expression expression : groupExpressions) {
                Column column = (Column)expression;
                groupByColumns.add(column);
            }
        }
        return groupByColumns;
    }

    public static String getSelectTableName(String sql) {
        Select select;
        SelectBody body;
        Statement statement = RouterManagerBeanFactory.getManager().getSqlStatement(sql);
        if (statement instanceof Select && (body = (select = (Select)statement).getSelectBody()) instanceof PlainSelect) {
            return DbRouterUtil.getTableNameWithPlainSelect((PlainSelect)body);
        }
        throw new DbrouterRuntimeException("must be a query sql");
    }

    public static Table getSelectTable(String sql) {
        PlainSelect plainSelect;
        FromItem fromItem;
        Select select;
        SelectBody body;
        Statement statement = RouterManagerBeanFactory.getManager().getSqlStatement(sql);
        if (statement instanceof Select && (body = (select = (Select)statement).getSelectBody()) instanceof PlainSelect && (fromItem = (plainSelect = (PlainSelect)body).getFromItem()) instanceof Table) {
            Table table = (Table)fromItem;
            return table;
        }
        throw new DbrouterRuntimeException("must be a query sql");
    }

    private static String getTableNameWithPlainSelect(PlainSelect plainSelect) {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            return table.getName();
        }
        return null;
    }

    public static Connection createConnection(DataSourceConfig config) throws SQLException {
        try {
            Class.forName(config.getDriver());
        }
        catch (ClassNotFoundException e) {
            throw new DbrouterRuntimeException(e);
        }
        Connection connection = DriverManager.getConnection(config.getUrl(), config.getUserName(), config.getPassword());
        connection.setAutoCommit(true);
        return connection;
    }

    public static int checkColumnIndex(String columnName, List<Column> columns) {
        if (!CollectionUtil.isEmpty(columns)) {
            for (int i = 0; i < columns.size(); ++i) {
                Column column = columns.get(i);
                String name = column.getColumnName();
                int index = name.indexOf(46);
                if (index != -1) {
                    name = name.substring(index + 1);
                }
                if (!name.equalsIgnoreCase(columnName)) continue;
                return i + 1;
            }
        }
        return -1;
    }

    public static int checkParamIndex(int columnIndex, List<Expression> expressions) {
        if (CollectionUtil.isEmpty(expressions) || columnIndex > expressions.size() || columnIndex < 1) {
            return -1;
        }
        int paramIndex = -1;
        for (int i = 0; i < columnIndex; ++i) {
            Expression expression = expressions.get(i);
            if (!(expression instanceof JdbcParameter)) continue;
            ++paramIndex;
        }
        return paramIndex;
    }

    public static Object deepCopy(Statement statement) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(statement);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        return ois.readObject();
    }

    public static String getLanguageByUrl(String url) {
        if (!StringUtil.isBlank((String)url) && JDBC_PATTERN.matcher(url).matches()) {
            String language = url.substring(5, url.indexOf(":", 5));
            if (JDBC_CHANGE_MAP.containsKey(language)) {
                return JDBC_CHANGE_MAP.get(language);
            }
            return language;
        }
        return null;
    }

    public static boolean isQuerySql(String sql) {
        Statement statement = RouterManagerBeanFactory.getManager().getSqlStatement(sql);
        return DbRouterUtil.isSelect(statement);
    }

    public static boolean isSelect(Statement statement) {
        return statement instanceof Select;
    }

    static {
        JDBC_CHANGE_MAP.put("jtds", "sqlserver");
        JDBC_CHANGE_MAP.put("microsoft", "sqlserver");
    }
}

