/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.dbrouter.util.SortOrder;
import org.tinygroup.jsqlparser.schema.Column;
import org.tinygroup.jsqlparser.statement.select.OrderByElement;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;

public class OrderByProcessor {
    private List<OrderByColumn> orderByList = new ArrayList<OrderByColumn>();
    private OrderByValues valueCache;
    private boolean[] orderTypes;
    private int[] orderByIndexs;
    private boolean hasOrderBy;
    private SortOrder sortOrder;

    public OrderByProcessor(PlainSelect plainSelect, ResultSet resultSet) throws SQLException {
        List orderByElements = plainSelect.getOrderByElements();
        if (!CollectionUtil.isEmpty((Collection)orderByElements)) {
            for (OrderByElement orderByElement : orderByElements) {
                Column column = (Column)orderByElement.getExpression();
                this.orderByList.add(new OrderByColumn(column, orderByElement.isAsc()));
            }
            this.orderTypes = new boolean[this.orderByList.size()];
            this.orderByIndexs = new int[this.orderByList.size()];
            for (int i = 0; i < this.orderTypes.length; ++i) {
                this.orderTypes[i] = this.orderByList.get(i).isAsc();
                this.orderByIndexs[i] = i;
            }
            this.hasOrderBy = true;
            this.sortOrder = new SortOrder(this.orderTypes, this.orderByIndexs);
        }
    }

    public boolean isHasOrderBy() {
        return this.hasOrderBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public boolean[] getOrderTypes() {
        return this.orderTypes;
    }

    public int[] getOrderByIndexs() {
        return this.orderByIndexs;
    }

    public void setValues(Object[] values) {
        this.valueCache = new OrderByValues(values);
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.valueCache = new OrderByValues(resultSet);
    }

    public OrderByValues getValueCache() {
        return this.valueCache;
    }

    public void setValueCache(OrderByValues valueCache) {
        this.valueCache = valueCache;
    }

    public void clearValueCache() {
        this.valueCache = null;
    }

    public class OrderByValues {
        private Object[] values;
        private ResultSet resultSet;

        public OrderByValues(Object[] values) {
            this.values = new Object[values.length];
            System.arraycopy(values, 0, this.values, 0, values.length);
        }

        public OrderByValues(ResultSet resultSet) throws SQLException {
            this.resultSet = resultSet;
            if (OrderByProcessor.this.orderByList.size() > 0) {
                this.values = new Object[OrderByProcessor.this.orderByList.size()];
                for (int i = 0; i < OrderByProcessor.this.orderByList.size(); ++i) {
                    Object value;
                    OrderByColumn orderBy = (OrderByColumn)OrderByProcessor.this.orderByList.get(i);
                    this.values[i] = value = resultSet.getObject(orderBy.getColumnName());
                }
            }
        }

        public Object[] getValues() {
            return this.values;
        }

        public void setValues(Object[] values) {
            this.values = new Object[values.length];
            System.arraycopy(values, 0, this.values, 0, values.length);
        }

        public ResultSet getResultSet() {
            return this.resultSet;
        }

        public void clearValueCache() {
            this.values = null;
        }

        public boolean isCurrentResult(ResultSet rs) {
            return rs.equals(this.resultSet);
        }
    }

    public class OrderByColumn {
        private Column column;
        private boolean asc = true;

        public OrderByColumn(Column column, boolean asc) {
            this.column = column;
            this.asc = asc;
        }

        public String getColumnName() {
            return this.column.getColumnName();
        }

        public boolean isAsc() {
            return this.asc;
        }
    }
}

