/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.util;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.CollectionUtil;

public class ParamObjectBuilder {
    private List<ParameterObject> params = new ArrayList<ParameterObject>();
    private Map<Integer, Object> indexParamValue = new HashMap<Integer, Object>();
    private Object[] paramsCache;
    private int paramNumber;

    public ParamObjectBuilder(int paramNumber) {
        this.paramNumber = paramNumber;
        this.paramsCache = new Object[paramNumber];
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.paramNumber) {
            throw new SQLException("columnIndex is invalid");
        }
    }

    public void expandParam() {
        ++this.paramNumber;
        Object[] newParamCache = new Object[this.paramNumber];
        for (int i = 0; i < this.paramsCache.length; ++i) {
            newParamCache[i] = this.paramsCache[i];
        }
        this.paramsCache = newParamCache;
    }

    public void addParamterObject(int parameterIndex, Object value) throws SQLException {
        this.checkColumnIndex(parameterIndex);
        this.paramsCache[parameterIndex - 1] = value;
        this.params.add(new ParameterObject(parameterIndex, value));
        this.indexParamValue.put(parameterIndex, value);
    }

    public void addNullParamterObject(int parameterIndex, int sqlType) throws SQLException {
        this.checkColumnIndex(parameterIndex);
        this.paramsCache[parameterIndex - 1] = null;
        this.params.add(new ParameterObject(parameterIndex, sqlType, null, true));
        this.indexParamValue.put(parameterIndex, null);
    }

    public void addNullParamterObject(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkColumnIndex(parameterIndex);
        this.paramsCache[parameterIndex - 1] = null;
        this.params.add(new ParameterObject(parameterIndex, sqlType, typeName, true));
        this.indexParamValue.put(parameterIndex, null);
    }

    public void addParamterObject(int parameterIndex, Object value, int targetSqlType) throws SQLException {
        this.checkColumnIndex(parameterIndex);
        this.paramsCache[parameterIndex - 1] = value;
        this.params.add(new ParameterObject(parameterIndex, value, targetSqlType));
        this.indexParamValue.put(parameterIndex, value);
    }

    public void addInputStreamParamterObject(int parameterIndex, InputStream value, int length, boolean asciiStream) throws SQLException {
        this.checkColumnIndex(parameterIndex);
        this.paramsCache[parameterIndex - 1] = value;
        this.params.add(new ParameterObject(parameterIndex, value, length, asciiStream));
        this.indexParamValue.put(parameterIndex, value);
    }

    public void addReaderParamterObject(int parameterIndex, Reader value, int length) throws SQLException {
        this.checkColumnIndex(parameterIndex);
        this.paramsCache[parameterIndex - 1] = value;
        this.params.add(new ParameterObject(parameterIndex, value, length));
        this.indexParamValue.put(parameterIndex, value);
    }

    public void addDateParamterObject(int parameterIndex, Date value, Calendar cal) throws SQLException {
        this.checkColumnIndex(parameterIndex);
        this.paramsCache[parameterIndex - 1] = value;
        this.params.add(new ParameterObject(parameterIndex, value, cal));
        this.indexParamValue.put(parameterIndex, value);
    }

    public void addTimeParamterObject(int parameterIndex, Time value, Calendar cal) throws SQLException {
        this.checkColumnIndex(parameterIndex);
        this.paramsCache[parameterIndex - 1] = value;
        this.params.add(new ParameterObject(parameterIndex, value, cal));
        this.indexParamValue.put(parameterIndex, value);
    }

    public void addTimestampParamterObject(int parameterIndex, Timestamp value, Calendar cal) throws SQLException {
        this.checkColumnIndex(parameterIndex);
        this.paramsCache[parameterIndex - 1] = value;
        this.params.add(new ParameterObject(parameterIndex, value, cal));
        this.indexParamValue.put(parameterIndex, value);
    }

    public void addParamterObject(int parameterIndex, Object value, int targetSqlType, int scale) throws SQLException {
        this.checkColumnIndex(parameterIndex);
        this.paramsCache[parameterIndex - 1] = value;
        this.params.add(new ParameterObject(parameterIndex, value, targetSqlType, scale));
        this.indexParamValue.put(parameterIndex, value);
    }

    public void removeParameterObject(int parameterIndex, Object value) throws SQLException {
        this.checkColumnIndex(parameterIndex);
        this.reBuildParamsCache(parameterIndex);
        this.params.remove(parameterIndex - 1);
        this.indexParamValue.remove(parameterIndex);
    }

    private void reBuildParamsCache(int parameterIndex) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < this.paramsCache.length; ++i) {
            if (i == parameterIndex - 1) continue;
            values.add(this.paramsCache[i]);
        }
        this.paramsCache = values.toArray();
    }

    public void clear() {
        this.params.clear();
    }

    public void setParamters(PreparedStatement preparedStatement) throws SQLException {
        if (!CollectionUtil.isEmpty(this.params)) {
            for (ParameterObject param : this.params) {
                param.setParamter(preparedStatement);
            }
        }
    }

    public Object[] getPreparedParams() {
        return this.paramsCache;
    }

    public int getParameterCount() {
        return this.params.size();
    }

    public Object getParamValue(int columnIndex) {
        return this.indexParamValue.get(columnIndex);
    }

    class ParameterObject {
        private int index;
        private Object value;
        private Integer targetSqlType;
        private Integer sqlType;
        private Integer scale;
        private String typeName;
        private int length;
        private Calendar cal;
        private boolean nullParam;
        private boolean asciiStream;

        public ParameterObject(int index, Object value) {
            this.index = index;
            this.value = value;
        }

        public ParameterObject(int index, Integer sqlType, String typeName, boolean nullParam) {
            this.index = index;
            this.sqlType = sqlType;
            this.nullParam = nullParam;
            this.typeName = typeName;
        }

        public ParameterObject(int index, Object value, int targetSqlType) {
            this(index, value);
            this.targetSqlType = targetSqlType;
        }

        public ParameterObject(int index, InputStream value, int length, boolean asciiStream) {
            this(index, value);
            this.asciiStream = asciiStream;
            this.length = length;
        }

        public ParameterObject(int index, Reader value, int length) {
            this(index, value);
            this.length = length;
        }

        public ParameterObject(int index, Date value, Calendar cal) {
            this(index, value);
            this.cal = cal;
        }

        public ParameterObject(int index, Time value, Calendar cal) {
            this(index, value);
            this.cal = cal;
        }

        public ParameterObject(int index, Timestamp value, Calendar cal) {
            this(index, value);
            this.cal = cal;
        }

        public ParameterObject(int index, Object value, int targetSqlType, Integer scale) {
            this(index, value, targetSqlType);
            this.scale = scale;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void setParamter(PreparedStatement preparedStatement) throws SQLException {
            if (this.value instanceof InputStream) {
                if (this.asciiStream) {
                    preparedStatement.setAsciiStream(this.index, (InputStream)this.value, this.length);
                } else {
                    preparedStatement.setBinaryStream(this.index, (InputStream)this.value, this.length);
                }
            } else if (this.value instanceof Reader) {
                preparedStatement.setCharacterStream(this.index, (Reader)this.value, this.length);
            } else if (this.value instanceof Time) {
                if (this.cal != null) {
                    preparedStatement.setTime(this.index, (Time)this.value, this.cal);
                } else {
                    preparedStatement.setTime(this.index, (Time)this.value);
                }
            } else if (this.value instanceof Timestamp) {
                if (this.cal != null) {
                    preparedStatement.setTimestamp(this.index, (Timestamp)this.value, this.cal);
                } else {
                    preparedStatement.setTimestamp(this.index, (Timestamp)this.value);
                }
            } else if (this.nullParam) {
                if (this.typeName != null) {
                    preparedStatement.setNull(this.index, this.sqlType, this.typeName);
                } else {
                    preparedStatement.setNull(this.index, this.sqlType);
                }
            } else if (this.targetSqlType != null) {
                if (this.scale != null) {
                    preparedStatement.setObject(this.index, this.value, this.targetSqlType, (int)this.scale);
                } else {
                    preparedStatement.setObject(this.index, this.value, this.targetSqlType);
                }
            } else {
                preparedStatement.setObject(this.index, this.value);
            }
        }
    }
}

