/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.value;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.tinygroup.dbrouter.exception.DbrouterRuntimeException;
import org.tinygroup.dbrouter.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataType {
    public static final int TYPE_RESULT_SET = -10;
    private static final List<DataType> TYPES = new ArrayList<DataType>();
    private static final List<DataType> TYPES_BY_VALUE_TYPE = new ArrayList<DataType>();
    private static final Map<String, DataType> TYPES_BY_NAME = new HashMap<String, DataType>();
    private int type;
    private String name;
    private int sqlType;
    private String jdbc;
    private int sqlTypePos;
    private long maxPrecision;
    private int minScale;
    private int maxScale;
    private boolean decimal;
    private String prefix;
    private String suffix;
    private String params;
    private boolean autoIncrement;
    private boolean caseSensitive;
    private boolean supportsPrecision;
    private boolean supportsScale;
    private long defaultPrecision;
    private int defaultScale;
    private int defaultDisplaySize;
    private boolean hidden;

    private static void add(int type, int sqlType, String jdbc, DataType dataType, String[] names, int memory) {
        for (int i = 0; i < names.length; ++i) {
            DataType dt = new DataType();
            dt.type = type;
            dt.sqlType = sqlType;
            dt.jdbc = jdbc;
            dt.name = names[i];
            dt.autoIncrement = dataType.autoIncrement;
            dt.decimal = dataType.decimal;
            dt.maxPrecision = dataType.maxPrecision;
            dt.maxScale = dataType.maxScale;
            dt.minScale = dataType.minScale;
            dt.params = dataType.params;
            dt.prefix = dataType.prefix;
            dt.suffix = dataType.suffix;
            dt.supportsPrecision = dataType.supportsPrecision;
            dt.supportsScale = dataType.supportsScale;
            dt.defaultPrecision = dataType.defaultPrecision;
            dt.defaultScale = dataType.defaultScale;
            dt.defaultDisplaySize = dataType.defaultDisplaySize;
            dt.caseSensitive = dataType.caseSensitive;
            dt.hidden = i > 0;
            for (DataType t2 : TYPES) {
                if (t2.sqlType != dt.sqlType) continue;
                ++dt.sqlTypePos;
            }
            TYPES_BY_NAME.put(dt.name, dt);
            if (TYPES_BY_VALUE_TYPE.get(type) == null) {
                TYPES_BY_VALUE_TYPE.set(type, dt);
            }
            TYPES.add(dt);
        }
    }

    private static DataType createDecimal(int maxPrecision, int defaultPrecision, int defaultScale, int defaultDisplaySize, boolean needsPrecisionAndScale, boolean autoInc) {
        DataType dataType = new DataType();
        dataType.maxPrecision = maxPrecision;
        dataType.defaultPrecision = defaultPrecision;
        dataType.defaultScale = defaultScale;
        dataType.defaultDisplaySize = defaultDisplaySize;
        if (needsPrecisionAndScale) {
            dataType.params = "PRECISION,SCALE";
            dataType.supportsPrecision = true;
            dataType.supportsScale = true;
        }
        dataType.decimal = true;
        dataType.autoIncrement = autoInc;
        return dataType;
    }

    private static DataType createDate(int precision, String prefix, int scale, int displaySize) {
        DataType dataType = new DataType();
        dataType.prefix = prefix + " '";
        dataType.suffix = "'";
        dataType.maxPrecision = precision;
        dataType.supportsScale = scale != 0;
        dataType.maxScale = scale;
        dataType.defaultPrecision = precision;
        dataType.defaultScale = scale;
        dataType.defaultDisplaySize = displaySize;
        return dataType;
    }

    private static DataType createString(boolean caseSensitive) {
        DataType dataType = new DataType();
        dataType.prefix = "'";
        dataType.suffix = "'";
        dataType.params = "LENGTH";
        dataType.caseSensitive = caseSensitive;
        dataType.supportsPrecision = true;
        dataType.maxPrecision = Integer.MAX_VALUE;
        dataType.defaultPrecision = Integer.MAX_VALUE;
        dataType.defaultDisplaySize = Integer.MAX_VALUE;
        return dataType;
    }

    private static DataType createLob() {
        DataType t = DataType.createString(true);
        t.maxPrecision = Long.MAX_VALUE;
        t.defaultPrecision = Long.MAX_VALUE;
        return t;
    }

    public static List<DataType> getTypes() {
        return TYPES;
    }

    public static String getTypeClassName(int type) {
        switch (type) {
            case 1: {
                return Boolean.class.getName();
            }
            case 2: {
                return Byte.class.getName();
            }
            case 3: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case 5: {
                return Long.class.getName();
            }
            case 6: {
                return BigDecimal.class.getName();
            }
            case 9: {
                return Time.class.getName();
            }
            case 10: {
                return Date.class.getName();
            }
            case 11: {
                return Timestamp.class.getName();
            }
            case 12: 
            case 20: {
                return byte[].class.getName();
            }
            case 13: 
            case 14: 
            case 21: {
                return String.class.getName();
            }
            case 15: {
                return Blob.class.getName();
            }
            case 16: {
                return Clob.class.getName();
            }
            case 7: {
                return Double.class.getName();
            }
            case 8: {
                return Float.class.getName();
            }
            case 0: {
                return null;
            }
            case 19: {
                return Object.class.getName();
            }
            case -1: {
                return Object.class.getName();
            }
            case 17: {
                return Array.class.getName();
            }
            case 18: {
                return ResultSet.class.getName();
            }
        }
        throw new DbrouterRuntimeException("type=" + type);
    }

    public static int convertSQLTypeToValueType(int sqlType) {
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                return 13;
            }
            case 2: 
            case 3: {
                return 6;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case -6: {
                return 2;
            }
            case -5: {
                return 5;
            }
            case 7: {
                return 8;
            }
            case 6: 
            case 8: {
                return 7;
            }
            case -4: 
            case -3: 
            case -2: {
                return 12;
            }
            case 1111: 
            case 2000: {
                return 19;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 9;
            }
            case 93: {
                return 11;
            }
            case 2004: {
                return 15;
            }
            case 0: 
            case 2005: {
                return 0;
            }
            case 2003: {
                return 17;
            }
            case -10: {
                return 18;
            }
        }
        throw new DbrouterRuntimeException(String.format("an unsupported sql type:%s", sqlType));
    }

    public static int getTypeFromClass(Class<?> x) {
        if (x == null || Void.TYPE == x) {
            return 0;
        }
        if (x.isPrimitive()) {
            x = DataType.getNonPrimitiveClass(x);
        }
        if (String.class == x) {
            return 13;
        }
        if (Integer.class == x) {
            return 4;
        }
        if (Long.class == x) {
            return 5;
        }
        if (Boolean.class == x) {
            return 1;
        }
        if (Double.class == x) {
            return 7;
        }
        if (Byte.class == x) {
            return 2;
        }
        if (Short.class == x) {
            return 3;
        }
        if (Character.class == x) {
            throw new DbrouterRuntimeException("char (not supported)");
        }
        if (Float.class == x) {
            return 8;
        }
        if (byte[].class == x) {
            return 12;
        }
        if (UUID.class == x) {
            return 20;
        }
        if (Void.class == x) {
            return 0;
        }
        if (BigDecimal.class.isAssignableFrom(x)) {
            return 6;
        }
        if (ResultSet.class.isAssignableFrom(x)) {
            return 18;
        }
        if (Value.ValueBlob.class.isAssignableFrom(x)) {
            return 15;
        }
        if (Value.ValueClob.class.isAssignableFrom(x)) {
            return 16;
        }
        if (Date.class.isAssignableFrom(x)) {
            return 10;
        }
        if (Time.class.isAssignableFrom(x)) {
            return 9;
        }
        if (Timestamp.class.isAssignableFrom(x)) {
            return 11;
        }
        if (java.util.Date.class.isAssignableFrom(x)) {
            return 11;
        }
        if (Reader.class.isAssignableFrom(x)) {
            return 16;
        }
        if (Clob.class.isAssignableFrom(x)) {
            return 16;
        }
        if (InputStream.class.isAssignableFrom(x)) {
            return 15;
        }
        if (Blob.class.isAssignableFrom(x)) {
            return 15;
        }
        if (Object[].class.isAssignableFrom(x)) {
            return 17;
        }
        return 19;
    }

    public static Class<?> getNonPrimitiveClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    public static boolean isLargeObject(int type) {
        return type == 15 || type == 16;
    }

    public static boolean isStringType(int type) {
        return type == 13 || type == 21 || type == 14;
    }

    public static boolean supportsAdd(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static int getAddProofType(int type) {
        switch (type) {
            case 2: {
                return 5;
            }
            case 8: {
                return 7;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 3: {
                return 5;
            }
        }
        return type;
    }

    public static Object getDefaultForPrimitiveType(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        throw new DbrouterRuntimeException("primitive=" + clazz.toString());
    }

    public static DataType getDataType(int type) {
        if (type == -1) {
            throw new DbrouterRuntimeException("unsupported data type");
        }
        DataType dt = TYPES_BY_VALUE_TYPE.get(type);
        if (dt == null) {
            dt = TYPES_BY_VALUE_TYPE.get(0);
        }
        return dt;
    }

    public static DataType getTypeByName(String s) {
        return TYPES_BY_NAME.get(s);
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String getJdbc() {
        return this.jdbc;
    }

    public int getSqlTypePos() {
        return this.sqlTypePos;
    }

    public long getMaxPrecision() {
        return this.maxPrecision;
    }

    public int getMinScale() {
        return this.minScale;
    }

    public int getMaxScale() {
        return this.maxScale;
    }

    public boolean isDecimal() {
        return this.decimal;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getParams() {
        return this.params;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isSupportsPrecision() {
        return this.supportsPrecision;
    }

    public boolean isSupportsScale() {
        return this.supportsScale;
    }

    public long getDefaultPrecision() {
        return this.defaultPrecision;
    }

    public int getDefaultScale() {
        return this.defaultScale;
    }

    public int getDefaultDisplaySize() {
        return this.defaultDisplaySize;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    static {
        for (int i = 0; i < 22; ++i) {
            TYPES_BY_VALUE_TYPE.add(null);
        }
        DataType.add(0, 0, "Null", new DataType(), new String[]{"NULL"}, 0);
        DataType.add(13, 12, "String", DataType.createString(true), new String[]{"VARCHAR", "VARCHAR2", "NVARCHAR", "NVARCHAR2", "VARCHAR_CASESENSITIVE", "CHARACTER VARYING", "TID"}, 48);
        DataType.add(13, -1, "String", DataType.createString(true), new String[]{"LONGVARCHAR", "LONGNVARCHAR"}, 48);
        DataType.add(21, 1, "String", DataType.createString(true), new String[]{"CHAR", "CHARACTER", "NCHAR"}, 48);
        DataType.add(14, 12, "String", DataType.createString(false), new String[]{"VARCHAR_IGNORECASE"}, 48);
        DataType.add(1, 16, "Boolean", DataType.createDecimal(1, 1, 0, 5, false, false), new String[]{"BOOLEAN", "BIT", "BOOL"}, 0);
        DataType.add(2, -6, "Byte", DataType.createDecimal(3, 3, 0, 4, false, false), new String[]{"TINYINT"}, 1);
        DataType.add(3, 5, "Short", DataType.createDecimal(5, 5, 0, 6, false, false), new String[]{"SMALLINT", "YEAR", "INT2"}, 20);
        DataType.add(4, 4, "Int", DataType.createDecimal(10, 10, 0, 11, false, false), new String[]{"INTEGER", "INT", "MEDIUMINT", "INT4", "SIGNED"}, 20);
        DataType.add(4, 4, "Int", DataType.createDecimal(10, 10, 0, 11, false, true), new String[]{"SERIAL"}, 20);
        DataType.add(5, -5, "Long", DataType.createDecimal(19, 19, 0, 20, false, false), new String[]{"BIGINT", "INT8", "LONG"}, 24);
        DataType.add(5, -5, "Long", DataType.createDecimal(19, 19, 0, 20, false, true), new String[]{"IDENTITY", "BIGSERIAL"}, 24);
        DataType.add(6, 3, "BigDecimal", DataType.createDecimal(Integer.MAX_VALUE, 65535, Short.MAX_VALUE, 65535, true, false), new String[]{"DECIMAL", "DEC"}, 64);
        DataType.add(6, 2, "BigDecimal", DataType.createDecimal(Integer.MAX_VALUE, 65535, Short.MAX_VALUE, 65535, true, false), new String[]{"NUMERIC", "NUMBER"}, 64);
        DataType.add(8, 7, "Float", DataType.createDecimal(7, 7, 0, 15, false, false), new String[]{"REAL", "FLOAT4"}, 24);
        DataType.add(7, 8, "Double", DataType.createDecimal(17, 17, 0, 24, false, false), new String[]{"DOUBLE", "DOUBLE PRECISION"}, 24);
        DataType.add(7, 6, "Double", DataType.createDecimal(17, 17, 0, 24, false, false), new String[]{"FLOAT", "FLOAT8"}, 24);
        DataType.add(9, 92, "Time", DataType.createDate(6, "TIME", 0, 8), new String[]{"TIME"}, 56);
        DataType.add(10, 91, "Date", DataType.createDate(8, "DATE", 0, 10), new String[]{"DATE"}, 56);
        DataType.add(11, 93, "Timestamp", DataType.createDate(23, "TIMESTAMP", 10, 23), new String[]{"TIMESTAMP", "DATETIME", "SMALLDATETIME"}, 56);
        DataType.add(12, -3, "Bytes", DataType.createString(false), new String[]{"VARBINARY"}, 32);
        DataType.add(12, -2, "Bytes", DataType.createString(false), new String[]{"BINARY", "RAW", "BYTEA", "LONG RAW"}, 32);
        DataType.add(12, -4, "Bytes", DataType.createString(false), new String[]{"LONGVARBINARY"}, 32);
        DataType.add(20, -2, "Bytes", DataType.createString(false), new String[]{"UUID"}, 32);
        DataType.add(19, 1111, "Object", DataType.createString(false), new String[]{"OTHER", "OBJECT", "JAVA_OBJECT"}, 24);
        DataType.add(15, 2004, "Blob", DataType.createLob(), new String[]{"BLOB", "TINYBLOB", "MEDIUMBLOB", "LONGBLOB", "IMAGE", "OID"}, 104);
        DataType.add(16, 2005, "Clob", DataType.createLob(), new String[]{"CLOB", "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT", "NTEXT", "NCLOB"}, 104);
        DataType dataType = new DataType();
        dataType.prefix = "(";
        dataType.suffix = "')";
        DataType.add(17, 2003, "Array", dataType, new String[]{"ARRAY"}, 32);
        dataType = new DataType();
        DataType.add(18, -10, "ResultSet", dataType, new String[]{"RESULT_SET"}, 400);
    }
}

