/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.docgen.fileresolver;

import org.tinygroup.docgen.DocumentGenerater;
import org.tinygroup.docgen.DocumentGeneraterManager;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;

public class TemplateFileProcessor
extends AbstractFileProcessor {
    private String fileExtName;
    private String documentType;
    private DocumentGenerater generate;
    private DocumentGeneraterManager manager;

    public DocumentGeneraterManager getManager() {
        return this.manager;
    }

    public void setManager(DocumentGeneraterManager manager) {
        this.manager = manager;
    }

    public String getFileExtName() {
        return this.fileExtName;
    }

    public void setFileExtName(String fileExtName) {
        this.fileExtName = fileExtName;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String docType) {
        this.documentType = docType;
    }

    public DocumentGenerater getGenerate() {
        return this.generate;
    }

    public void setGenerate(DocumentGenerater generate) {
        this.generate = generate;
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(this.fileExtName);
    }

    public void process() {
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664\u6587\u6863\u6a21\u677f\u5b8f\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            this.generate.removeMacroFile(fileObject);
            this.caches.remove(fileObject.getAbsolutePath());
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664\u6587\u6863\u6a21\u677f\u5b8f\u914d\u7f6e\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7d\u6587\u6863\u6a21\u677f\u5b8f\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            FileObject oldFileObject = (FileObject)this.caches.get(fileObject.getAbsolutePath());
            if (oldFileObject != null) {
                this.generate.removeMacroFile(oldFileObject);
            }
            this.generate.addMacroFile(fileObject);
            this.caches.put(fileObject.getAbsolutePath(), fileObject);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7d\u6587\u6863\u6a21\u677f\u5b8f\u914d\u7f6e\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        this.manager.putDocumentGenerater(this.documentType, this.generate);
    }
}

