/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.docgen.function;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.function.AbstractTemplateFunction;

public class StaticClassFunction
extends AbstractTemplateFunction {
    private Class<?> clazz;

    public StaticClassFunction(String names, String className) {
        super(names);
        try {
            this.clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public StaticClassFunction(String names, Class<?> clazz) {
        super(names);
        this.clazz = clazz;
    }

    public Object execute(Template template, TemplateContext context, Object ... parameters) throws TemplateException {
        if (parameters.length == 0 || !(parameters[0] instanceof String)) {
            this.notSupported(parameters);
        }
        String methodName = parameters[0].toString();
        try {
            Object[] objects = Arrays.copyOfRange(parameters, 1, parameters.length);
            Method method = this.findMethod(methodName, objects);
            return method.invoke(null, objects);
        }
        catch (Exception e) {
            throw new TemplateException((Throwable)e);
        }
    }

    private Method findMethod(String methodName, Object[] objects) throws Exception {
        for (Method method : this.clazz.getDeclaredMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!method.getName().equals(methodName) || !this.checkParameter(objects, parameterTypes)) continue;
            return method;
        }
        throw new TemplateException("\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u65b9\u6cd5\u540d:" + methodName);
    }

    private boolean checkParameter(Object[] objects, Class<?>[] parameterTypes) {
        if (parameterTypes.length != objects.length) {
            return false;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (parameterTypes[i].isInstance(objects[i])) continue;
            return false;
        }
        return true;
    }
}

