/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.docgen.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.tinygroup.context.Context;
import org.tinygroup.docgen.DocumentGenerater;
import org.tinygroup.template.ResourceLoader;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.impl.TemplateContextDefault;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.loader.FileObjectResourceLoader;
import org.tinygroup.template.loader.FileResourceManager;
import org.tinygroup.template.loader.StringResourceLoader;
import org.tinygroup.template.loader.TemplateLoadUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;

public class DocumentGeneraterImpl
implements DocumentGenerater<TemplateEngine> {
    private TemplateEngine templateGenerater;
    private StringResourceLoader stringResourceLoader;
    private FileObjectResourceLoader fileObjectResourceLoader;
    private FileResourceManager fileResourceManager;

    @Override
    public TemplateEngine getTemplateGenerater() {
        return this.templateGenerater;
    }

    @Override
    public void setTemplateGenerater(TemplateEngine generater) {
        this.templateGenerater = generater;
    }

    public FileResourceManager getFileResourceManager() {
        return this.fileResourceManager;
    }

    public void setFileResourceManager(FileResourceManager fileResourceManager) {
        this.fileResourceManager = fileResourceManager;
    }

    @Override
    public void generate(FileObject fileObject, Context context, OutputStream writer) {
        try {
            Template template = this.templateGenerater.findTemplate(fileObject.getPath());
            this.generate(template, context, writer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void generate(String path, Context context, OutputStream writer) {
        try {
            FileObject fileObject = VFS.resolveFile((String)path);
            this.generate(fileObject, context, writer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void generate(Template template, Context context, OutputStream writer) {
        try {
            if (context instanceof TemplateContext) {
                this.templateGenerater.renderTemplate(template, (TemplateContext)context, writer);
            } else {
                TemplateContextDefault newContext = new TemplateContextDefault();
                newContext.setParent(context);
                this.templateGenerater.renderTemplate(template, (TemplateContext)newContext, writer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addMacroFile(FileObject fileObject) {
        try {
            if (this.fileObjectResourceLoader == null) {
                this.fileObjectResourceLoader = new FileObjectResourceLoader(null, null, fileObject.getExtName());
                this.templateGenerater.addResourceLoader((ResourceLoader)this.fileObjectResourceLoader);
            }
            this.fileResourceManager.addResource(fileObject.getPath(), fileObject);
            Template template = TemplateLoadUtil.loadComponent((TemplateEngineDefault)((TemplateEngineDefault)this.templateGenerater), (FileObject)fileObject);
            this.updateTemplate(template);
            this.templateGenerater.getRepositories().put(fileObject.getPath(), template);
            this.templateGenerater.registerMacroLibrary(template);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeMacroFile(FileObject fileObject) {
        try {
            this.fileResourceManager.removeResource(fileObject);
            this.templateGenerater.removeTemplate(fileObject.getPath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void generate(String path, Context context, File outputFile) {
        try {
            this.generate(path, context, (OutputStream)new FileOutputStream(outputFile));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String evaluteString(Context context, String inputString) {
        if (this.stringResourceLoader == null) {
            this.initStringResourceLoader();
        }
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        try {
            Template template = this.stringResourceLoader.createTemplate(inputString);
            this.updateTemplate(template);
            this.generate(template, context, (OutputStream)writer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    private void initStringResourceLoader() {
        this.stringResourceLoader = new StringResourceLoader();
        this.stringResourceLoader.setTemplateEngine(this.templateGenerater);
    }

    private void updateTemplate(Template template) {
        if (template.getTemplateEngine() == null) {
            template.setTemplateEngine(this.templateGenerater);
        }
        if (template.getTemplateContext().getParent() == null) {
            template.getTemplateContext().setParent((Context)this.templateGenerater.getTemplateContext());
        }
    }
}

