/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.exception.Error;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorContext
implements Serializable {
    private static final long serialVersionUID = 6436061876740168390L;
    private List<Error> errorStack = new ArrayList<Error>();
    private String thirdPartyError;
    private static final String SPLIT = "|";

    public Error fetchCurrentError() {
        if (!this.errorStack.isEmpty()) {
            return this.errorStack.get(this.errorStack.size() - 1);
        }
        return null;
    }

    public String fetchCurrentErrorCode() {
        if (!this.errorStack.isEmpty()) {
            return this.errorStack.get(this.errorStack.size() - 1).getErrorCode().toString();
        }
        return null;
    }

    public Error fetchRootError() {
        if (!this.errorStack.isEmpty()) {
            return this.errorStack.get(0);
        }
        return null;
    }

    public void addError(Error error) {
        if (this.errorStack == null) {
            this.errorStack = new ArrayList<Error>();
        }
        this.errorStack.add(error);
    }

    public String toDigest() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.errorStack.size(); i > 0; --i) {
            if (i == this.errorStack.size()) {
                sb.append(this.digest(this.errorStack.get(i - 1)));
                continue;
            }
            sb.append(SPLIT).append(this.digest(this.errorStack.get(i - 1)));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.errorStack.size(); i > 0; --i) {
            if (i == this.errorStack.size()) {
                sb.append(this.errorStack.get(i - 1));
                continue;
            }
            sb.append(SPLIT).append(this.errorStack.get(i - 1));
        }
        return sb.toString();
    }

    private String digest(Error error) {
        if (null == error) {
            return null;
        }
        return error.toDigest();
    }

    public List<Error> getErrorStack() {
        return this.errorStack;
    }

    public void setErrorStack(List<Error> errorStack) {
        this.errorStack = errorStack;
    }

    public String getThirdPartyError() {
        return this.thirdPartyError;
    }

    public void setThirdPartyError(String thirdPartyError) {
        this.thirdPartyError = thirdPartyError;
    }
}

