/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.exception;

import java.util.List;
import java.util.Locale;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.commons.tools.ExceptionUtil;
import org.tinygroup.context.Context;
import org.tinygroup.exception.ErrorCode;
import org.tinygroup.exception.ErrorCodeFactory;
import org.tinygroup.exception.ErrorContext;
import org.tinygroup.exception.util.ErrorUtil;
import org.tinygroup.i18n.I18nMessage;
import org.tinygroup.i18n.I18nMessageFactory;

public class BaseRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -1141168272047460629L;
    private static final I18nMessage i18nMessage = I18nMessageFactory.getI18nMessages();
    private String errorMsg;
    private ErrorCode errorCode;

    public String getMessage() {
        return String.format("[%s] :", this.errorCode) + this.errorMsg;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public BaseRuntimeException(String errorCode, Object ... params) {
        this(errorCode, "", LocaleUtil.getContext().getLocale(), params);
    }

    public BaseRuntimeException(String errorCode, String defaultErrorMsg, Object ... params) {
        this(errorCode, defaultErrorMsg, LocaleUtil.getContext().getLocale(), params);
    }

    public BaseRuntimeException(String errorCode, String defaultErrorMsg, Locale locale, Object ... params) {
        String errorI18nMsg = i18nMessage.getMessage(errorCode, locale, defaultErrorMsg, params);
        this.errorCode = ErrorCodeFactory.parseErrorCode(errorCode, this);
        this.errorMsg = errorI18nMsg;
    }

    public BaseRuntimeException(String errorCode, Throwable throwable, Object ... params) {
        this(errorCode, "", LocaleUtil.getContext().getLocale(), throwable, params);
    }

    public BaseRuntimeException(String errorCode, String defaultErrorMsg, Throwable throwable, Object ... params) {
        this(errorCode, defaultErrorMsg, LocaleUtil.getContext().getLocale(), throwable, params);
    }

    public BaseRuntimeException(String errorCode, String defaultErrorMsg, Locale locale, Throwable throwable, Object ... params) {
        super(throwable);
        String errorI18nMsg = i18nMessage.getMessage(errorCode, locale, defaultErrorMsg, params);
        this.errorCode = ErrorCodeFactory.parseErrorCode(errorCode, this);
        this.errorMsg = errorI18nMsg;
    }

    public BaseRuntimeException(String errorCode, Context context, Locale locale) {
        this(errorCode, "", context, locale);
    }

    public BaseRuntimeException(String errorCode, String defaultErrorMsg, Context context, Locale locale) {
        String errorI18nMsg;
        this.errorMsg = errorI18nMsg = i18nMessage.getMessage(errorCode, defaultErrorMsg, context, locale);
        this.errorCode = ErrorCodeFactory.parseErrorCode(errorCode, this);
    }

    public BaseRuntimeException(String errorCode, Context context) {
        this(errorCode, "", context, LocaleUtil.getContext().getLocale());
    }

    public BaseRuntimeException() {
    }

    public BaseRuntimeException(String message, Throwable cause) {
        super(message, cause);
        this.errorMsg = message;
    }

    public BaseRuntimeException(String message) {
        super(message);
        this.errorMsg = message;
    }

    public BaseRuntimeException(Throwable cause) {
        super(cause);
    }

    public static ErrorContext getErrorContext(Throwable throwable) {
        ErrorContext errorContext = new ErrorContext();
        List causes = ExceptionUtil.getCauses((Throwable)throwable, (boolean)true);
        for (Throwable cause : causes) {
            if (!(cause instanceof BaseRuntimeException)) continue;
            BaseRuntimeException exception = (BaseRuntimeException)cause;
            ErrorUtil.makeAndAddError(errorContext, exception.getErrorCode(), exception.getMessage());
        }
        return errorContext;
    }

    public boolean contains(Class exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause == this) {
            return false;
        }
        if (cause instanceof BaseRuntimeException) {
            return ((BaseRuntimeException)cause).contains(exType);
        }
        while (cause != null) {
            if (exType.isInstance(cause)) {
                return true;
            }
            if (cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return false;
    }
}

