/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.exception.util;

import org.tinygroup.exception.Error;
import org.tinygroup.exception.ErrorCode;
import org.tinygroup.exception.ErrorContext;
import org.tinygroup.exception.constant.ErrorLevel;
import org.tinygroup.exception.constant.ErrorType;
import org.tinygroup.exception.errorcode.AbstractErrorCode;
import org.tinygroup.exception.errorcode.ErrorCodeDefault;

public class ErrorUtil {
    private static String appName;

    private ErrorUtil() {
    }

    public static ErrorCodeDefault makeErrorCode(String errorType, String errorLevel, int errorScene, int errorSpecific, String errorPrefix) {
        return new ErrorCodeDefault(ErrorType.find(errorType), ErrorLevel.find(errorLevel), errorScene, errorSpecific, errorPrefix);
    }

    public static Error makeError(ErrorCode errorCode, String message) {
        Error error = new Error();
        error.setErrorCode(errorCode);
        error.setErrorMsg(message);
        error.setErrorSource(ErrorUtil.getAppName());
        return error;
    }

    public static Error makeError(ErrorCode errorCode, String message, String location) {
        Error error = new Error();
        error.setErrorCode(errorCode);
        error.setErrorMsg(message);
        error.setErrorSource(location);
        return error;
    }

    public static ErrorContext addError(Error error) {
        return ErrorUtil.addError(null, error);
    }

    public static ErrorContext addError(ErrorContext context, Error error) {
        if (context == null) {
            context = new ErrorContext();
        }
        if (error == null) {
            return context;
        }
        context.addError(error);
        return context;
    }

    public static ErrorContext makeAndAddError(ErrorContext context, ErrorCode errorCode, String message) {
        Error error = ErrorUtil.makeError(errorCode, message);
        return ErrorUtil.addError(context, error);
    }

    public static ErrorContext makeAndAddError(AbstractErrorCode errorCode, String message) {
        Error error = ErrorUtil.makeError(errorCode, message);
        return ErrorUtil.addError(error);
    }

    public static String getAppName() {
        if (null == appName || "".equals(appName)) {
            return "unknown";
        }
        return appName;
    }

    public static void setAppName(String appName) {
        ErrorUtil.appName = appName;
    }
}

