/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fileresolver;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.tinygroup.commons.tools.FileUtil;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.FileResolverUtil;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.fileresolver.impl.FileResolverImpl;
import org.tinygroup.fileresolver.impl.FullContextFileFinder;
import org.tinygroup.fileresolver.impl.FullContextFileRepositoryImpl;
import org.tinygroup.parser.Document;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class FullContentFileResposityTest
extends TestCase {
    private static final String FILE_PATH = "/org/tinygroup/fileresolver/FileResolver.class";
    private static FullContextFileRepository repository;
    private static boolean hasInited;

    void init() {
        repository = new FullContextFileRepositoryImpl();
        FileResolverImpl fileResolver = new FileResolverImpl();
        FullContextFileFinder finder = new FullContextFileFinder();
        XmlStringParser parse = new XmlStringParser();
        Document document = parse.parse((Object)"<full-context-file-finder><file ext-name=\"class\" content-type=\"application/test\" /></full-context-file-finder>");
        finder.config((XmlNode)document.getRoot(), null);
        finder.setFullContextFileRepository(repository);
        fileResolver.addFileProcessor((FileProcessor)finder);
        fileResolver.addResolvePath(FileResolverUtil.getClassPath((FileResolver)fileResolver));
        fileResolver.addIncludePathPattern("org\\.tinygroup\\.(.)*\\.jar");
        fileResolver.resolve();
    }

    protected void setUp() throws Exception {
        if (!hasInited) {
            this.init();
            hasInited = true;
        }
    }

    protected void tearDown() throws Exception {
    }

    public void testAddSearchPath() throws IOException {
        File testFile;
        FileObject fileObject = repository.getFileObject("test.xml");
        File director = new File("./test");
        if (!director.exists()) {
            director.mkdirs();
        }
        if (!(testFile = new File("./test/test.xml")).exists()) {
            testFile.createNewFile();
        }
        repository.addSearchPath("./test");
        fileObject = repository.getFileObject("/test.xml");
        FullContentFileResposityTest.assertTrue((fileObject != null ? 1 : 0) != 0);
        FileUtil.delete((File)director);
    }

    public void testGetFileObject() {
        FileObject fileObject = repository.getFileObject(FILE_PATH);
        FullContentFileResposityTest.assertEquals((String)"FileResolver.class", (String)fileObject.getFileName());
    }

    public void testRemoveFileObject() {
        FileObject beforeRemove = repository.getFileObject(FILE_PATH);
        FullContentFileResposityTest.assertTrue((beforeRemove != null ? 1 : 0) != 0);
        repository.removeFileObject(FILE_PATH);
        repository.addFileObject(FILE_PATH, beforeRemove);
    }

    public void testGetFileContentType() {
        FullContentFileResposityTest.assertEquals((String)"application/test", (String)repository.getFileContentType("class"));
    }

    public void testGetRootFileObject() {
        FileObject fileObject = repository.getRootFileObject(FILE_PATH);
        System.out.println(fileObject.getAbsolutePath());
        FullContentFileResposityTest.assertTrue((boolean)fileObject.getAbsolutePath().endsWith("classes"));
    }
}

