/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fileresolver.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.fileresolver.impl.ExcludeContextFileFinder;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;

public class FullContextFileRepositoryImpl
implements FullContextFileRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(FullContextFileRepositoryImpl.class);
    private Map<String, FileObject> fileMap = new HashMap<String, FileObject>();
    private Map<String, String> fileTypeMap;
    private Map<String, FileObject> searchPathMap = new HashMap<String, FileObject>();
    private ExcludeContextFileFinder excludeContextFileFinder;

    public void setExcludeContextFileFinder(ExcludeContextFileFinder excludeContextFileFinder) {
        this.excludeContextFileFinder = excludeContextFileFinder;
    }

    @Override
    public void addSearchPath(String searchPath) {
        FileObject fileObject = VFS.resolveFile((String)searchPath);
        this.searchPathMap.put(searchPath, fileObject);
        this.addFileObject(fileObject);
    }

    private void addFileObject(FileObject fileObject) {
        if (fileObject.isFolder()) {
            if (fileObject.getChildren() != null) {
                for (FileObject child : fileObject.getChildren()) {
                    this.addFileObject(child);
                }
            }
        } else {
            this.addFileObject(fileObject.getPath(), fileObject);
        }
    }

    @Override
    public void addFileObject(String path, FileObject fileObject) {
        if (this.excludeContextFileFinder.checkMatch(fileObject)) {
            this.fileMap.put(path, fileObject);
        }
    }

    @Override
    public FileObject getFileObject(String path) {
        FileObject fileObject = this.fileMap.get(path);
        if (fileObject == null && !this.searchPathMap.isEmpty()) {
            for (String searchPath : this.searchPathMap.keySet()) {
                FileObject searchPathObject = this.searchPathMap.get(searchPath);
                if (searchPathObject == null) {
                    throw new RuntimeException(String.format("[searchPath:%s],\u4e0d\u662f\u641c\u7d22\u7684\u8ddf\u8def\u5f84", searchPath));
                }
                fileObject = searchPathObject.getFileObject(path);
                if (fileObject != null && fileObject.isExist() && fileObject != searchPathObject) {
                    this.addFileObject(path, fileObject);
                    break;
                }
                fileObject = null;
            }
        }
        if (fileObject != null && this.excludeContextFileFinder.checkMatch(fileObject)) {
            return fileObject;
        }
        return null;
    }

    @Override
    public void removeFileObject(String path) {
        this.fileMap.remove(path);
    }

    @Override
    public void setFileTypeMap(Map<String, String> fileTypeMap) {
        this.fileTypeMap = fileTypeMap;
    }

    @Override
    public String getFileContentType(String extName) {
        return this.fileTypeMap.get(extName);
    }

    @Override
    public FileObject getRootFileObject(String path) {
        String fullPath = this.getFileObject(path).getAbsolutePath();
        return VFS.resolveFile((String)fullPath.substring(0, fullPath.length() - path.length() + 1));
    }

    @Override
    public FileObject getFileObjectDetectLocale(String path) {
        StringBuilder sb = new StringBuilder();
        sb.append(path.substring(0, path.lastIndexOf(46)));
        sb.append(".");
        String locale = LocaleUtil.getContext().getLocale().toString();
        sb.append(locale);
        sb.append(path.substring(path.lastIndexOf(46)));
        FileObject fileObject = this.getFileObject(sb.toString());
        if (fileObject != null && fileObject.isExist()) {
            LOGGER.logMessage(LogLevel.DEBUG, "\u627e\u5230\u5e76\u4f7f\u7528[{}]\u7684[{}]\u8bed\u8a00\u6587\u4ef6:{}", new Object[]{path, locale, fileObject.getPath()});
            return fileObject;
        }
        return this.getFileObject(path);
    }

    @Override
    public Map<String, FileObject> getAllFileObjects() {
        return this.fileMap;
    }
}

