/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fileresolver.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.config.Configuration;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xmlparser.node.XmlNode;

public class ExcludeContextFileFinder
implements Configuration {
    private static final String FILE = "file";
    private static final String CONTENT_TYPE = "content-type";
    private static final String EXT_NAME = "ext-name";
    private static final String EXCLUDE_FULL_CONTEXT_FILE_FINDER_PATH = "/application/file-resolver-configuration/exclude-full-context-file-finder";
    protected XmlNode applicationConfig;
    protected XmlNode componentConfig;
    private Map<String, String> excludeFileExtensionMap = new HashMap<String, String>();

    public boolean checkMatch(FileObject fileObject) {
        return fileObject == null || !this.excludeFileExtensionMap.containsKey(fileObject.getExtName());
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        this.applicationConfig = applicationConfig;
        this.componentConfig = componentConfig;
        List fileNodes = ConfigurationUtil.combineSubList((String)FILE, (XmlNode)applicationConfig, (XmlNode)componentConfig);
        for (XmlNode fileNode : fileNodes) {
            String extName = fileNode.getAttribute(EXT_NAME);
            String contentType = fileNode.getAttribute(CONTENT_TYPE);
            this.excludeFileExtensionMap.put(extName, contentType);
        }
    }

    public String getApplicationNodePath() {
        return EXCLUDE_FULL_CONTEXT_FILE_FINDER_PATH;
    }

    public Map<String, String> getExcludeFileExtensionMap() {
        return this.excludeFileExtensionMap;
    }

    public String getComponentConfigPath() {
        return null;
    }

    public XmlNode getComponentConfig() {
        return this.componentConfig;
    }

    public XmlNode getApplicationConfig() {
        return this.applicationConfig;
    }
}

