/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fileresolver.impl;

import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.i18n.I18nMessageFactory;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;

public class I18nFileProcessor
extends AbstractFileProcessor {
    private static final String PROPERTIES_FILE_EXTENSION = ".properties";
    private static final String CUSTOMIZE_PROPERTIES_FILE_EXTENSION = ".cproperties";
    private static final String I18N_FOLDER_NAME = "i18n";
    private String i18nFolderName = "i18n";

    public String getI18nFolderName() {
        return this.i18nFolderName;
    }

    public void setI18nFolderName(String i18nFolderName) {
        this.i18nFolderName = i18nFolderName;
    }

    @Override
    protected boolean checkMatch(FileObject fileObject) {
        return (fileObject.getFileName().endsWith(PROPERTIES_FILE_EXTENSION) || fileObject.getFileName().endsWith(CUSTOMIZE_PROPERTIES_FILE_EXTENSION)) && fileObject.getParent().getFileName().equals(I18N_FOLDER_NAME);
    }

    private void process(FileObject fileObject) {
        LOGGER.logMessage(LogLevel.INFO, "\u627e\u5230\u56fd\u9645\u5316\u8d44\u6e90\u914d\u7f6e\u6587\u4ef6[{0}]\uff0c\u5e76\u5f00\u59cb\u52a0\u8f7d...", new Object[]{fileObject.getAbsolutePath()});
        Locale locale = this.getLocale(fileObject);
        Properties oldProperties = (Properties)this.caches.get(fileObject.getAbsolutePath());
        if (oldProperties != null) {
            if (fileObject.getFileName().endsWith(PROPERTIES_FILE_EXTENSION)) {
                I18nMessageFactory.removeResource((Locale)locale, (Properties)oldProperties);
            } else {
                I18nMessageFactory.removeCustomizeResource((Locale)locale, (Properties)oldProperties);
            }
        }
        try {
            Properties properties = this.convertXml(fileObject);
            if (fileObject.getFileName().endsWith(PROPERTIES_FILE_EXTENSION)) {
                I18nMessageFactory.addResource((Locale)locale, (Properties)properties);
            } else {
                I18nMessageFactory.addCustomizeResource((Locale)locale, (Properties)properties);
            }
            this.caches.put(fileObject.getAbsolutePath(), properties);
            LOGGER.logMessage(LogLevel.INFO, "\u56fd\u9645\u5316\u8d44\u6e90\u914d\u7f6e\u6587\u4ef6[{0}]\uff0c\u52a0\u8f7d\u5b8c\u6bd5\u3002", new Object[]{fileObject.getAbsolutePath()});
        }
        catch (Exception e) {
            LOGGER.errorMessage("\u8f7d\u5165\u8d44\u6e90\u6587\u4ef6[{}]\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties convertXml(FileObject fileObject) {
        InputStream inputStream = null;
        Properties properties = new Properties();
        inputStream = fileObject.getInputStream();
        properties.load(inputStream);
        Properties properties2 = properties;
        if (inputStream == null) return properties2;
        try {
            inputStream.close();
            return properties2;
        }
        catch (Exception e) {
            LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{0}", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
        }
        return properties2;
        catch (Exception e) {
            try {
                LOGGER.errorMessage("\u8f7d\u5165\u8d44\u6e90\u6587\u4ef6[{0}]\u51fa\u73b0\u5f02\u5e38", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
                if (inputStream == null) return null;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{0}", (Throwable)e2, new Object[]{fileObject.getAbsolutePath()});
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return null;
            }
            catch (Exception e3) {
                LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{0}", (Throwable)e3, new Object[]{fileObject.getAbsolutePath()});
            }
            return null;
        }
    }

    private Locale getLocale(FileObject fileObject) {
        String baseName = fileObject.getFileName();
        int start = baseName.indexOf("_") + 1;
        int end = baseName.length() - PROPERTIES_FILE_EXTENSION.length();
        String localeStr = null;
        if (start > 0) {
            localeStr = baseName.substring(start, end);
        }
        Locale locale = LocaleUtil.getContext().getLocale();
        if (localeStr != null && localeStr.length() > 0) {
            String[] loc = localeStr.split("_");
            locale = loc.length == 2 ? new Locale(loc[0], loc[1]) : new Locale(loc[0]);
        }
        return locale;
    }

    @Override
    public void process() {
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u79fb\u9664\u56fd\u9645\u5316\u8d44\u6e90\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Locale locale = this.getLocale(fileObject);
            Properties properties = (Properties)this.caches.get(fileObject.getAbsolutePath());
            if (properties != null) {
                if (fileObject.getFileName().endsWith(PROPERTIES_FILE_EXTENSION)) {
                    I18nMessageFactory.removeResource((Locale)locale, (Properties)properties);
                } else {
                    I18nMessageFactory.removeCustomizeResource((Locale)locale, (Properties)properties);
                }
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664\u56fd\u9645\u5316\u8d44\u6e90\u914d\u7f6e\u6587\u4ef6[{0}],\u5b8c\u6210", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            this.process(fileObject);
        }
    }

    @Override
    public void setFileResolver(FileResolver fileResolver) {
    }

    @Override
    public int getOrder() {
        return -2147483638;
    }
}

