/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fileresolver.impl;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;
import org.tinygroup.xstream.config.XStreamConfiguration;

public class XStreamFileProcessor
extends AbstractFileProcessor {
    private static final String XSTREAM_FILE_EXTENSION = ".xstream.xml";
    private String xstreamFileExtension = ".xstream.xml";

    public String getXstreamFileExtension() {
        return this.xstreamFileExtension;
    }

    public void setXstreamFileExtension(String xstreamFileExtension) {
        this.xstreamFileExtension = xstreamFileExtension;
    }

    @Override
    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(XSTREAM_FILE_EXTENSION);
    }

    private void process(FileObject fileObject) {
        try {
            LOGGER.logMessage(LogLevel.INFO, "\u627e\u5230XStream\u914d\u7f6e\u6587\u4ef6[{0}]\uff0c\u5e76\u5f00\u59cb\u52a0\u8f7d...", new Object[]{fileObject.getAbsolutePath()});
            XStream loadXStream = XStreamFactory.getXStream();
            InputStream inputStream = fileObject.getInputStream();
            XStreamConfiguration xstreamConfiguration = (XStreamConfiguration)loadXStream.fromXML(inputStream);
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            XStreamFactory.parse((XStreamConfiguration)xstreamConfiguration);
            LOGGER.logMessage(LogLevel.INFO, "XStream\u914d\u7f6e\u6587\u4ef6[{0}]\uff0c\u52a0\u8f7d\u5b8c\u6bd5\u3002", new Object[]{fileObject.getAbsolutePath()});
        }
        catch (Exception e) {
            LOGGER.errorMessage(String.format("processing file <%s>", fileObject.getAbsolutePath()), (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void process() {
        for (FileObject fileObject : this.fileObjects) {
            this.process(fileObject);
        }
    }

    @Override
    public void setFileResolver(FileResolver fileResolver) {
    }

    @Override
    public int getOrder() {
        return -2147483628;
    }
}

