/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fileresolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.commons.file.FileDealUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.FileObjectFilter;
import org.tinygroup.vfs.FileObjectProcessor;
import org.tinygroup.vfs.VFS;
import org.tinygroup.vfs.impl.JarSchemaProvider;

public class FileResolverUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResolverUtil.class);

    private FileResolverUtil() {
    }

    public static void addClassPathPattern(FileResolver resolver) {
        resolver.addIncludePathPattern("[\\/]classes\\b");
        resolver.addIncludePathPattern("[\\/]test-classes\\b");
    }

    public static List<String> getClassPath(FileResolver resolver) {
        ArrayList<String> classPathFileObjects = new ArrayList<String>();
        String classPathProperty = System.getProperty("java.class.path").toString();
        String operateSys = System.getProperty("os.name").toLowerCase();
        String[] classPaths = null;
        classPaths = operateSys.indexOf("windows") >= 0 ? classPathProperty.split(";") : classPathProperty.split(":");
        if (classPaths == null) {
            return classPathFileObjects;
        }
        for (String classPath : classPaths) {
            FileObject fileObject;
            if (classPath.length() <= 0 || !FileResolverUtil.isInclude(fileObject = VFS.resolveFile((String)classPath), resolver)) continue;
            classPathFileObjects.add(fileObject.getAbsolutePath());
        }
        return classPathFileObjects;
    }

    public static boolean isInclude(FileObject fileObject, FileResolver resolver) {
        if (fileObject == null || !fileObject.isExist()) {
            return false;
        }
        URL url = fileObject.getURL();
        if ("file".equals(url.getProtocol()) && fileObject.getSchemaProvider() instanceof JarSchemaProvider) {
            Map<String, Pattern> includePathPatternMap = resolver.getIncludePathPatternMap();
            for (String patternString : includePathPatternMap.keySet()) {
                Pattern pattern = includePathPatternMap.get(patternString);
                Matcher matcher = pattern.matcher(fileObject.getFileName());
                if (!matcher.find()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static List<String> dealJarSource(FileResolver resolver, String path) {
        ArrayList<String> list = new ArrayList<String>();
        if (path.indexOf("!") < 0) {
            path = path.substring(0, path.length() - "META-INF/MANIFEST.MF".length() - 1);
            path = path.substring(path.indexOf(58) + 1);
            list.add(path);
            return list;
        }
        String[] pathArray = path.split("!");
        if (pathArray.length <= 2) {
            list.add(pathArray[0]);
            return list;
        }
        LOGGER.infoMessage("\u5b58\u5728jar\u5305\u5d4c\u5957jar\u5305\u7684\u8def\u5f84\uff1a{}", new Object[]{path});
        try {
            return FileDealUtil.unpack((String[])pathArray);
        }
        catch (IOException e) {
            LOGGER.errorMessage("\u89e3\u6790\u8def\u5f84\uff1a{}\u53d1\u751f\u5f02\u5e38", (Throwable)e, new Object[]{path});
            return list;
        }
    }

    public static List<String> getWebLibJars(FileResolver resolver) throws Exception {
        final ArrayList<String> classPaths = new ArrayList<String>();
        LOGGER.logMessage(LogLevel.INFO, "\u67e5\u627eWeb\u5de5\u7a0b\u4e2d\u7684jar\u6587\u4ef6\u5217\u8868\u5f00\u59cb...");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> urls = loader.getResources("META-INF/MANIFEST.MF");
        Map<String, Pattern> includePathPatternMap = resolver.getIncludePathPatternMap();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            String path = url.toString();
            path = path.replaceAll("/\\./", "/");
            List<String> paths = FileResolverUtil.dealJarSource(resolver, path);
            for (String searchPath : paths) {
                FileResolverUtil.checkPath(resolver, classPaths, includePathPatternMap, url, searchPath);
            }
        }
        String webinfPath = (String)ConfigurationUtil.getConfigurationManager().getConfiguration().get("TINY_WEBROOT");
        if (!StringUtil.isEmpty((String)webinfPath)) {
            FileObject webroot = VFS.resolveFile((String)webinfPath);
            webroot.foreach(new FileObjectFilter(){

                public boolean accept(FileObject fileObject) {
                    return fileObject.getFileName().endsWith(".jar");
                }
            }, new FileObjectProcessor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(FileObject fileObject) {
                    FileObject mfObject = fileObject.getFileObject("META-INF/MANIFEST.MF");
                    if (mfObject == null || !mfObject.isExist()) {
                        return;
                    }
                    InputStream inputStream = null;
                    try {
                        inputStream = mfObject.getInputStream();
                        Manifest mf = new Manifest(inputStream);
                        Attributes attributes = mf.getMainAttributes();
                        String isTinyProject = attributes.getValue("IsTinyProject");
                        if ("true".equals(isTinyProject)) {
                            LOGGER.logMessage(LogLevel.INFO, "\u6587\u4ef6<{}>\u7531\u4e8e\u5728MANIFEST.MF\u6587\u4ef6\u4e2d\u58f0\u660e\u4e86IsTinyProject: true\u800c\u88ab\u626b\u63cf\u3002", new Object[]{fileObject});
                            FileResolverUtil.addJarFile(classPaths, fileObject.getAbsolutePath());
                        }
                    }
                    catch (IOException e) {
                        LOGGER.logMessage(LogLevel.WARN, "\u89e3\u6790MANIFEST.MF\u53d1\u751f\u5f02\u5e38:{}", new Object[]{mfObject.getAbsolutePath()});
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
        }
        LOGGER.logMessage(LogLevel.INFO, "\u67e5\u627eWeb\u5de5\u7a0b\u4e2d\u7684jar\u6587\u4ef6\u5217\u8868\u5b8c\u6210\u3002");
        return classPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkPath(FileResolver resolver, List<String> classPaths, Map<String, Pattern> includePathPatternMap, URL url, String path) throws IOException {
        LOGGER.logMessage(LogLevel.DEBUG, "\u5f00\u59cb\u68c0\u67e5\u8def\u5f84{}\u662f\u5426\u53ef\u88ab\u626b\u63cf", new Object[]{path});
        FileObject fileObject = VFS.resolveFile((String)path);
        if (includePathPatternMap != null && !includePathPatternMap.isEmpty() && FileResolverUtil.isInclude(fileObject, resolver)) {
            LOGGER.logMessage(LogLevel.INFO, "\u6587\u4ef6<{}>\u7531\u4e8e\u7b26\u5408\u6b63\u5219\u89c4\u5219\u800c\u88ab\u626b\u63cf\u3002", new Object[]{fileObject});
            FileResolverUtil.addJarFile(classPaths, fileObject.getAbsolutePath());
            LOGGER.logMessage(LogLevel.DEBUG, "\u68c0\u67e5\u8def\u5f84{}\u7ed3\u675f", new Object[]{path});
            return;
        }
        if (fileObject.isExist()) {
            InputStream stream = null;
            try {
                stream = url.openStream();
                Manifest mf = new Manifest(stream);
                Attributes attributes = mf.getMainAttributes();
                String isTinyProject = attributes.getValue("IsTinyProject");
                if ("true".equals(isTinyProject)) {
                    LOGGER.logMessage(LogLevel.INFO, "\u6587\u4ef6<{}>\u7531\u4e8e\u5728MANIFEST.MF\u6587\u4ef6\u4e2d\u58f0\u660e\u4e86IsTinyProject: true\u800c\u88ab\u626b\u63cf\u3002", new Object[]{fileObject});
                    FileResolverUtil.addJarFile(classPaths, fileObject.getAbsolutePath());
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        LOGGER.logMessage(LogLevel.DEBUG, "\u68c0\u67e5\u8def\u5f84{}\u7ed3\u675f", new Object[]{path});
    }

    private static void addJarFile(List<String> classPaths, String path) {
        LOGGER.logMessage(LogLevel.INFO, "\u626b\u63cf\u5230jar\u6587\u4ef6<{}>\u3002", new Object[]{path});
        classPaths.add(path);
    }

    public static List<String> getWebClasses() {
        String libPath;
        FileObject fileObject;
        ArrayList<String> allScanningPath = new ArrayList<String>();
        LOGGER.logMessage(LogLevel.INFO, "\u67e5\u627eWEB-INF/classes\u8def\u5f84\u5f00\u59cb...");
        URL url = FileResolverUtil.getURL();
        String path = url.toString();
        LOGGER.logMessage(LogLevel.INFO, "WEB-INF/classes\u8def\u5f84\u662f:{}", new Object[]{path});
        if (path.indexOf("!") < 0) {
            String webInfPath;
            fileObject = VFS.resolveFile((String)path);
            allScanningPath.add(fileObject.getAbsolutePath());
            libPath = path.replaceAll("/classes", "/lib");
            LOGGER.logMessage(LogLevel.INFO, "WEB-INF/lib\u8def\u5f84\u662f:{}", new Object[]{libPath});
            FileObject libFileObject = VFS.resolveFile((String)libPath);
            allScanningPath.add(libFileObject.getAbsolutePath());
            int index = path.indexOf("/classes");
            if (index > 0 && (webInfPath = path.substring(0, index)).endsWith("WEB-INF")) {
                LOGGER.logMessage(LogLevel.INFO, "WEB-INF\u8def\u5f84\u662f:{}", new Object[]{webInfPath});
                FileObject webInfoFileObject = VFS.resolveFile((String)webInfPath);
                allScanningPath.add(webInfoFileObject.getAbsolutePath());
            }
        } else {
            path = url.getFile().split("!")[0];
            fileObject = VFS.resolveFile((String)path);
            allScanningPath.add(fileObject.getAbsolutePath());
            libPath = path.substring(0, path.lastIndexOf(47));
            LOGGER.logMessage(LogLevel.INFO, "WEB-INF/lib\u8def\u5f84\u662f:{}", new Object[]{libPath});
            FileObject libFileObject = VFS.resolveFile((String)libPath);
            allScanningPath.add(libFileObject.getAbsolutePath());
        }
        LOGGER.logMessage(LogLevel.INFO, "\u67e5\u627eWEB-INF/classes\u8def\u5f84\u5b8c\u6210\u3002");
        String webinfPath = (String)ConfigurationUtil.getConfigurationManager().getConfiguration().get("TINY_WEBROOT");
        if (StringUtil.isEmpty((String)webinfPath)) {
            LOGGER.logMessage(LogLevel.WARN, "WEBROOT\u53d8\u91cf\u627e\u4e0d\u5230");
            return allScanningPath;
        }
        FileObject fileObject2 = VFS.resolveFile((String)webinfPath);
        allScanningPath.add(fileObject2.getAbsolutePath());
        return allScanningPath;
    }

    private static URL getURL() {
        URL url = null;
        String weblogicMode = ConfigurationUtil.getConfigurationManager().getConfiguration("WEBLOGIC_MODE");
        if (weblogicMode != null && "true".equalsIgnoreCase(weblogicMode)) {
            url = FileResolverUtil.class.getClassLoader().getResource("/");
            if (url == null) {
                url = FileResolverUtil.class.getClassLoader().getResource("");
            }
        } else {
            url = FileResolverUtil.class.getResource("/");
            if (url == null) {
                url = FileResolverUtil.class.getResource("");
            }
        }
        return url;
    }
}

