/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fileresolver.impl;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xmlparser.node.XmlNode;

public abstract class AbstractFileProcessor
implements FileProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileProcessor.class);
    protected List<FileObject> fileObjects = new ArrayList<FileObject>();
    protected List<FileObject> changeList = new ArrayList<FileObject>();
    protected List<FileObject> deleteList = new ArrayList<FileObject>();
    protected FileResolver fileResolver;
    protected XmlNode applicationConfig;
    protected XmlNode componentConfig;
    protected Map<String, Object> caches = new HashMap<String, Object>();

    @Override
    public boolean isMatch(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return false;
        }
        return this.checkMatch(fileObject);
    }

    protected abstract boolean checkMatch(FileObject var1);

    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    @Override
    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    @Override
    public void add(FileObject fileObject) {
        this.fileObjects.add(fileObject);
        this.changeList.add(fileObject);
    }

    @Override
    public void noChange(FileObject fileObject) {
    }

    @Override
    public void modify(FileObject fileObject) {
        this.fileObjects.add(fileObject);
        this.changeList.add(fileObject);
    }

    @Override
    public void delete(FileObject fileObject) {
        this.fileObjects.remove(fileObject);
        this.deleteList.add(fileObject);
    }

    @Override
    public void clean() {
        this.fileObjects.clear();
        this.changeList.clear();
        this.deleteList.clear();
    }

    @Override
    public boolean supportRefresh() {
        return true;
    }

    public String getApplicationNodePath() {
        return null;
    }

    public String getComponentConfigPath() {
        return null;
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        this.applicationConfig = applicationConfig;
        this.componentConfig = componentConfig;
    }

    public XmlNode getComponentConfig() {
        return this.componentConfig;
    }

    public XmlNode getApplicationConfig() {
        return this.applicationConfig;
    }

    public int getOrder() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T convertFromXml(XStream stream, FileObject fileObject) {
        Object object;
        InputStream inputStream = null;
        try {
            inputStream = fileObject.getInputStream();
            object = stream.fromXML(inputStream);
            if (inputStream == null) return (T)object;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u8f6c\u6362XML\u6587\u4ef6\u6210Xstream\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38,\u8def\u5f84:" + fileObject.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    LOGGER.error("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e2, new Object[]{fileObject.getAbsolutePath()});
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return (T)object;
        }
        catch (Exception e) {
            LOGGER.error("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
        }
        return (T)object;
    }
}

