/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fileresolver.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.config.Configuration;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.fileresolver.impl.ExcludeContextFileFinder;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xmlparser.node.XmlNode;

public class FullContextFileFinder
extends AbstractFileProcessor
implements Configuration {
    private static final String FILE = "file";
    private static final String CONTENT_TYPE = "content-type";
    private static final String EXT_NAME = "ext-name";
    private static final String FULL_CONTEXT_FILE_FINDER_PATH = "/application/file-resolver-configuration/full-context-file-finder";
    FullContextFileRepository fullContextFileRepository;
    ExcludeContextFileFinder excludeContextFileFinder;
    private Map<String, String> extFileContentTypeMap = new HashMap<String, String>();

    public FullContextFileRepository getFullContextFileRepository() {
        return this.fullContextFileRepository;
    }

    public void setFullContextFileRepository(FullContextFileRepository fullContextFileRepository) {
        this.fullContextFileRepository = fullContextFileRepository;
    }

    public void setExtFileContentTypeMap(Map<String, String> extFileContentTypeMap) {
        this.extFileContentTypeMap = extFileContentTypeMap;
    }

    public void setExcludeContextFileFinder(ExcludeContextFileFinder excludeContextFileFinder) {
        this.excludeContextFileFinder = excludeContextFileFinder;
    }

    @Override
    protected boolean checkMatch(FileObject fileObject) {
        if (this.excludeContextFileFinder.getExcludeFileExtensionMap().size() > 0) {
            return this.excludeContextFileFinder.checkMatch(fileObject);
        }
        if (this.extFileContentTypeMap.size() > 0) {
            return this.extFileContentTypeMap.containsKey(fileObject.getExtName());
        }
        return true;
    }

    private void process(FileObject fileObject) {
        this.fullContextFileRepository.addFileObject(fileObject.getPath(), fileObject);
    }

    @Override
    public void process() {
        this.fullContextFileRepository.setFileTypeMap(this.extFileContentTypeMap);
        for (FileObject fileObject : this.deleteList) {
            this.fullContextFileRepository.removeFileObject(fileObject.getPath());
        }
        for (FileObject fileObject : this.changeList) {
            this.process(fileObject);
        }
    }

    @Override
    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        super.config(applicationConfig, componentConfig);
        List fileNodes = ConfigurationUtil.combineSubList((String)FILE, (XmlNode)applicationConfig, (XmlNode)componentConfig);
        for (XmlNode fileNode : fileNodes) {
            String extName = fileNode.getAttribute(EXT_NAME);
            String contentType = fileNode.getAttribute(CONTENT_TYPE);
            this.extFileContentTypeMap.put(extName, contentType);
        }
        FileResolver fileResolver = this.getFileResolver();
        if (fileResolver != null) {
            for (String searchPath : fileResolver.getScanningPaths()) {
                this.fullContextFileRepository.addSearchPath(searchPath);
            }
        }
    }

    @Override
    public String getApplicationNodePath() {
        return FULL_CONTEXT_FILE_FINDER_PATH;
    }

    @Override
    public String getComponentConfigPath() {
        return "/filefind.config.xml";
    }
}

