/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flow.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.tinygroup.annotation.AnnotationClassAction;
import org.tinygroup.annotation.AnnotationPropertyAction;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.AnnotationUtils;
import org.tinygroup.event.Parameter;
import org.tinygroup.flow.FlowExecutor;
import org.tinygroup.flow.annotation.config.ComponentDefine;
import org.tinygroup.flow.annotation.config.ComponentParameter;
import org.tinygroup.flow.annotation.config.ComponentResult;
import org.tinygroup.flow.annotation.config.ComponentType;
import org.tinygroup.flow.config.Result;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowComponentAnnotationAction
implements AnnotationClassAction,
AnnotationPropertyAction {
    private FlowExecutor executor;
    private FlowExecutor pageflowExecutor;
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowComponentAnnotationAction.class);

    public <T> void process(Class<T> clazz, Annotation annotation) {
        if (this.executor == null) {
            this.executor = (FlowExecutor)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("flowExecutor");
        }
        if (this.pageflowExecutor == null) {
            this.pageflowExecutor = (FlowExecutor)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("pageFlowExecutor");
        }
        ComponentDefine annoDefine = (ComponentDefine)AnnotationUtils.findAnnotation(clazz, ComponentDefine.class);
        org.tinygroup.flow.config.ComponentDefine componentDefine = new org.tinygroup.flow.config.ComponentDefine();
        this.setBasicProperty(annoDefine, componentDefine);
        ComponentType type = annoDefine.type();
        if (type.equals((Object)ComponentType.BOTH)) {
            this.executor.addComponent(componentDefine);
            this.pageflowExecutor.addComponent(componentDefine);
        } else if (type.equals((Object)ComponentType.FLOW)) {
            this.executor.addComponent(componentDefine);
        } else if (type.equals((Object)ComponentType.PAGEFLOW)) {
            this.pageflowExecutor.addComponent(componentDefine);
        }
    }

    private void setBasicProperty(ComponentDefine annoDefine, org.tinygroup.flow.config.ComponentDefine componentDefine) {
        componentDefine.setName(annoDefine.name());
        componentDefine.setBean(annoDefine.bean());
        componentDefine.setCategory(annoDefine.category());
        componentDefine.setIcon(annoDefine.icon());
        componentDefine.setShortDescription(annoDefine.shortDescription());
        componentDefine.setLongDescription(annoDefine.longDescription());
        componentDefine.setTitle(annoDefine.title());
    }

    public <T> void process(Class<T> clazz, Field field, Annotation annotation) {
        ComponentDefine annoDefine = (ComponentDefine)AnnotationUtils.findAnnotation(clazz, ComponentDefine.class);
        String componentName = annoDefine.name();
        org.tinygroup.flow.config.ComponentDefine componentDefine = this.executor.getComponentDefine(componentName);
        if (componentDefine != null) {
            this.propertiesProcess(componentDefine, annotation);
        }
        if ((componentDefine = this.pageflowExecutor.getComponentDefine(componentName)) != null) {
            this.propertiesProcess(componentDefine, annotation);
        }
        if (componentDefine == null) {
            LOGGER.logMessage(LogLevel.WARN, "\u4e0d\u5b58\u5728\u7ec4\u4ef6\u540d\u79f0\u4e3a\uff1a[{0}]\u7684\u7ec4\u4ef6\u4fe1\u606f", new Object[]{componentName});
        }
    }

    public void propertiesProcess(org.tinygroup.flow.config.ComponentDefine componentDefine, Annotation annotation) {
        if (annotation.annotationType().isAssignableFrom(ComponentParameter.class)) {
            ComponentParameter annoParameter = (ComponentParameter)annotation;
            Parameter parameter = this.createParameter(annoParameter);
            componentDefine.addParamter(parameter);
        } else if (annotation.annotationType().isAssignableFrom(ComponentResult.class)) {
            ComponentResult componentResult = (ComponentResult)annotation;
            Result result = this.createResult(componentResult);
            componentDefine.addResult(result);
        }
    }

    private Result createResult(ComponentResult componentResult) {
        Result result = new Result();
        result.setArray(componentResult.array());
        result.setCollectionType(componentResult.collectionType());
        result.setDescription(componentResult.description());
        result.setName(componentResult.name());
        result.setRequired(componentResult.required());
        result.setTitle(componentResult.title());
        result.setType(componentResult.type());
        return result;
    }

    private Parameter createParameter(ComponentParameter annoParameter) {
        Parameter parameter = new Parameter();
        parameter.setArray(annoParameter.array());
        parameter.setCollectionType(annoParameter.collectionType());
        parameter.setDescription(annoParameter.description());
        parameter.setName(annoParameter.name());
        parameter.setRequired(annoParameter.required());
        parameter.setScope(annoParameter.scope());
        parameter.setTitle(annoParameter.title());
        parameter.setType(annoParameter.type());
        parameter.setValidatorSence(annoParameter.validatorScene());
        return parameter;
    }
}

