/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flow.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.flow.config.FlowProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="component")
public class Component
implements Serializable {
    private static final long serialVersionUID = -4678446337219023016L;
    private List<FlowProperty> properties;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private String title;
    private String description;
    private transient Map<String, FlowProperty> propertyMap;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, FlowProperty> getPropertyMap() {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap<String, FlowProperty>();
            for (FlowProperty property : this.getProperties()) {
                this.propertyMap.put(property.getName(), property);
            }
        }
        return this.propertyMap;
    }

    public List<FlowProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<FlowProperty>();
        }
        return this.properties;
    }

    public void setProperties(List<FlowProperty> properties) {
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void combile(Component component) {
        if (this.name == null) {
            this.name = component.getName();
        }
        if (this.title == null) {
            this.title = component.getTitle();
        }
        List<FlowProperty> parentProperties = component.getProperties();
        if (this.properties == null) {
            this.properties = parentProperties;
            return;
        }
        if (parentProperties != null) {
            for (FlowProperty pProperty : parentProperties) {
                FlowProperty myProperty = this.getPropertyMap().get(pProperty.getName());
                if (myProperty != null) continue;
                this.getPropertyMap().put(pProperty.getName(), pProperty);
            }
        }
    }
}

