/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flow.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.event.Parameter;
import org.tinygroup.flow.FlowExecutor;
import org.tinygroup.flow.config.Node;
import org.tinygroup.flow.exception.FlowRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="flow")
public class Flow
implements Serializable {
    private static final long serialVersionUID = -7228372373320970405L;
    @XStreamAsAttribute
    @XStreamAlias(value="extend-flow-id")
    private String extendFlowId;
    @XStreamAsAttribute
    private String id;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private String title;
    private String description;
    private List<Node> nodes;
    private transient Map<String, Node> nodeMap;
    private transient FlowExecutor flowExecutor;
    private transient boolean assembled = false;
    @XStreamAsAttribute
    @XStreamAlias(value="private-context")
    private boolean privateContext = false;
    @XStreamAsAttribute
    private boolean enable;
    @XStreamAsAttribute
    private String category;
    @XStreamAlias(value="parameters")
    private List<Parameter> parameters;

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public List<Parameter> getInputParameters() {
        if (this.parameters == null) {
            return null;
        }
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        for (Parameter parameter : this.parameters) {
            if (parameter.getScope() != null && !parameter.getScope().equalsIgnoreCase("both") && !parameter.getScope().equalsIgnoreCase("in")) continue;
            result.add(parameter);
        }
        return result;
    }

    public List<Parameter> getOutputParameters() {
        if (this.parameters == null) {
            return this.parameters;
        }
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        for (Parameter parameter : this.parameters) {
            if (parameter.getScope() != null && !parameter.getScope().equalsIgnoreCase("both") && !parameter.getScope().equalsIgnoreCase("out")) continue;
            result.add(parameter);
        }
        return result;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isPrivateContext() {
        return this.privateContext;
    }

    public void setPrivateContext(boolean privateContext) {
        this.privateContext = privateContext;
    }

    public void assemble() {
        if (this.assembled) {
            return;
        }
        if (this.extendFlowId != null) {
            Flow parentFlow = this.flowExecutor.getFlowIdMap().get(this.extendFlowId);
            if (parentFlow == null) {
                throw new FlowRuntimeException("flow.flowNotExist", this.extendFlowId);
            }
            parentFlow.assemble();
            this.copyFlow(parentFlow);
        }
        this.assembled = true;
    }

    private void copyFlow(Flow parentFlow) {
        List<Node> tmpNodes = this.nodes;
        this.nodes = new ArrayList<Node>();
        this.nodes.addAll(parentFlow.getNodes());
        for (Node node : tmpNodes) {
            Node parentNode = parentFlow.getNodeMap().get(node.getId());
            if (parentNode == null) {
                this.getNodeMap().put(node.getId(), node);
                this.nodes.add(node);
                continue;
            }
            int index = this.nodes.indexOf(parentNode);
            this.nodes.remove(index);
            node.combine(parentNode);
            this.nodes.add(index, node);
        }
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public String getExtendFlowId() {
        return this.extendFlowId;
    }

    public void setExtendFlowId(String extendFlowId) {
        this.extendFlowId = extendFlowId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, Node> getNodeMap() {
        if (this.nodeMap == null) {
            this.nodeMap = new HashMap<String, Node>();
            if (this.nodes != null) {
                for (Node node : this.nodes) {
                    this.nodeMap.put(node.getId(), node);
                }
            }
        }
        return this.nodeMap;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getServiceName() {
        return this.id;
    }

    public List<Parameter> getParameters() {
        List<Parameter> p = this.getInputParameters();
        if (p != null) {
            return p;
        }
        return new ArrayList<Parameter>();
    }
}

