/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flow.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.Context;
import org.tinygroup.flow.config.Component;
import org.tinygroup.flow.config.NextNode;
import org.tinygroup.flow.util.FlowElUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="node")
public class Node
implements Serializable {
    private static final long serialVersionUID = 6987481042476758848L;
    @XStreamAsAttribute
    private String id;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private String title;
    private String description;
    private Component component;
    @XStreamAlias(value="next-nodes")
    private List<NextNode> nextNodes;
    @XStreamAlias(value="default-node-id")
    @XStreamAsAttribute
    private String defaultNodeId;
    private transient Map<String, String> nextExceptionNodeMap = new HashMap<String, String>();
    private transient List<String> nextExceptionList = new ArrayList<String>();
    private transient boolean exceptionMapComputed = false;

    public String getDefaultNodeId() {
        return this.defaultNodeId;
    }

    public void setDefaultNodeId(String defaultNodeId) {
        this.defaultNodeId = defaultNodeId;
    }

    public Map<String, String> getNextExceptionNodeMap() {
        if (this.exceptionMapComputed) {
            return this.nextExceptionNodeMap;
        }
        this.initNextExceptionInfo();
        return this.nextExceptionNodeMap;
    }

    public List<String> getNextExceptionList() {
        if (this.exceptionMapComputed) {
            return this.nextExceptionList;
        }
        this.initNextExceptionInfo();
        return this.nextExceptionList;
    }

    private void initNextExceptionInfo() {
        this.nextExceptionNodeMap = new HashMap<String, String>();
        this.nextExceptionList = new ArrayList<String>();
        if (this.nextNodes != null) {
            for (int i = 0; i < this.nextNodes.size(); ++i) {
                NextNode nextNode = this.nextNodes.get(i);
                String exceptionType = nextNode.getExceptionType();
                if (exceptionType == null || exceptionType.length() <= 0 || this.nextExceptionNodeMap.containsKey(exceptionType)) continue;
                this.nextExceptionNodeMap.put(exceptionType, nextNode.getNextNodeId());
                this.nextExceptionList.add(exceptionType);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public List<NextNode> getNextNodes() {
        return this.nextNodes;
    }

    public void setNextNodes(List<NextNode> nextNodes) {
        this.nextNodes = nextNodes;
    }

    public String getNextNodeId(Context context) {
        if (this.nextNodes == null) {
            return this.getDefaultNodeId();
        }
        for (NextNode node : this.nextNodes) {
            String exception = node.getExceptionType();
            if (!StringUtil.isBlank((String)exception)) continue;
            String el = node.getEl();
            if (StringUtil.isBlank((String)el)) {
                return node.getNextNodeId();
            }
            if (!FlowElUtil.executeCondition(el, context, this.getClass().getClassLoader())) continue;
            return node.getNextNodeId();
        }
        return this.getDefaultNodeId();
    }

    public void combine(Node parentNode) {
        if (this.name == null) {
            this.name = parentNode.getName();
        }
        if (this.defaultNodeId == null) {
            this.defaultNodeId = parentNode.getDefaultNodeId();
        }
        if (this.title == null) {
            this.title = parentNode.getTitle();
        }
        if (this.description == null) {
            this.description = parentNode.getDescription();
        }
        if (this.component == null) {
            this.component = parentNode.getComponent();
        } else if (this.component.getName().equals(parentNode.getComponent().getName())) {
            this.component.combile(parentNode.getComponent());
        }
        this.combineNextNode(parentNode);
    }

    private void combineNextNode(Node parentNode) {
        if (parentNode.getNextNodes() != null && (this.nextNodes == null || this.nextNodes.size() == 0)) {
            this.nextNodes = parentNode.getNextNodes();
        }
    }
}

