/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flow.containers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.flow.ComponentInterface;
import org.tinygroup.flow.config.ComponentDefine;
import org.tinygroup.flow.config.ComponentDefines;
import org.tinygroup.flow.exception.FlowRuntimeException;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentContainers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentContainers.class);
    private Map<String, ComponentDefine> beanIdMap = new HashMap<String, ComponentDefine>();
    private Map<String, ComponentDefine> nameMap = new HashMap<String, ComponentDefine>();

    public void addComponents(ComponentDefines components) {
        for (ComponentDefine component : components.getComponentDefines()) {
            this.addComponent(component);
        }
    }

    public void removeComponents(ComponentDefines components) {
        for (ComponentDefine component : components.getComponentDefines()) {
            this.removeComponent(component);
        }
    }

    public void removeComponent(ComponentDefine component) {
        if (component == null) {
            return;
        }
        LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664\u7ec4\u4ef6Component[name:{0},bean:{1}]", new Object[]{component.getName(), component.getBean()});
        this.beanIdMap.remove(component.getBean());
        this.nameMap.remove(component.getName());
    }

    public ComponentInterface getComponentInstance(String componentName) {
        if (this.nameMap.get(componentName) != null) {
            return (ComponentInterface)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(this.nameMap.get(componentName).getBean());
        }
        throw new FlowRuntimeException("flow.componentNotExist", componentName);
    }

    public void addComponent(ComponentDefine component) {
        if (component == null) {
            return;
        }
        LOGGER.logMessage(LogLevel.INFO, "\u6dfb\u52a0\u7ec4\u4ef6Component[name:{0},bean:{1}]", new Object[]{component.getName(), component.getBean()});
        this.beanIdMap.put(component.getBean(), component);
        this.nameMap.put(component.getName(), component);
    }

    public ComponentDefine getComponentDefine(String componentName) {
        return this.nameMap.get(componentName);
    }

    public List<ComponentDefine> getComponentDefines() {
        ArrayList<ComponentDefine> componentDefines = new ArrayList<ComponentDefine>();
        for (ComponentDefine define : this.nameMap.values()) {
            componentDefines.add(define);
        }
        return componentDefines;
    }
}

