/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flow.fileresolver;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.flow.FlowExecutor;
import org.tinygroup.flow.config.ComponentDefines;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class FlowComponentRemoveProcessor
extends AbstractFileProcessor {
    private static final String FLOW_COMPONENT_EXT_FILENAME = ".fc.xml";
    private FlowExecutor flowExecutor;

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(FLOW_COMPONENT_EXT_FILENAME);
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"flow");
        for (FileObject fileObject : this.fileObjects) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u5220\u9664\u903b\u8f91\u7ec4\u4ef6fc\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            InputStream inputStream = fileObject.getInputStream();
            ComponentDefines components = (ComponentDefines)stream.fromXML(inputStream);
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            this.flowExecutor.removeComponents(components);
            LOGGER.logMessage(LogLevel.INFO, "\u5220\u9664\u903b\u8f91\u7ec4\u4ef6fc\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    public void setFileResolver(FileResolver fileResolver) {
    }
}

