/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flow.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.tinygroup.commons.match.SimpleTypeMatcher;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.ValueUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.context2object.util.Context2ObjectUtil;
import org.tinygroup.event.Parameter;
import org.tinygroup.flow.ComponentInterface;
import org.tinygroup.flow.FlowExecutor;
import org.tinygroup.flow.config.Component;
import org.tinygroup.flow.config.ComponentDefine;
import org.tinygroup.flow.config.ComponentDefines;
import org.tinygroup.flow.config.Flow;
import org.tinygroup.flow.config.FlowProperty;
import org.tinygroup.flow.config.Node;
import org.tinygroup.flow.containers.ComponentContainers;
import org.tinygroup.flow.exception.FlowRuntimeException;
import org.tinygroup.flow.util.FlowElUtil;
import org.tinygroup.format.FormatProvider;
import org.tinygroup.format.Formater;
import org.tinygroup.format.impl.ContextFormater;
import org.tinygroup.format.impl.FormaterImpl;
import org.tinygroup.i18n.I18nMessageFactory;
import org.tinygroup.i18n.I18nMessages;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowExecutorImpl
implements FlowExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowExecutorImpl.class);
    private static Map<String, Class<?>> exceptionMap = new HashMap();
    private static transient Formater formater = new FormaterImpl();
    private Map<String, Flow> flowIdMap = new HashMap<String, Flow>();
    private I18nMessages i18nMessages = I18nMessageFactory.getI18nMessages();
    private boolean change;
    private ComponentContainers containers = new ComponentContainers();

    @Override
    public Map<String, Flow> getFlowIdMap() {
        return this.flowIdMap;
    }

    @Override
    public void execute(String flowId, Context context) {
        this.execute(flowId, null, context);
    }

    @Override
    public void execute(String flowId, String nodeId, Context context) {
        LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u6267\u884c\u6d41\u7a0b[flowId:{0},nodeId:{1}]\u6267\u884c", new Object[]{flowId, nodeId});
        if (!this.getFlowIdMap().containsKey(flowId)) {
            LOGGER.log(LogLevel.ERROR, "flow.flowNotExist", new Object[]{flowId});
            throw new FlowRuntimeException("flow.flowNotExist", flowId);
        }
        Flow flow = this.getFlowIdMap().get(flowId);
        Node node = this.getNode(flow, nodeId);
        if (node != null) {
            this.logContext(context);
            this.checkInputParameter(flow, context);
            this.execute(flow, node, context);
            this.checkOutputParameter(flow, context);
            this.logContext(context);
        }
        LOGGER.logMessage(LogLevel.INFO, "\u6d41\u7a0b[flowId:{0},nodeId:{1}]\u6267\u884c\u5b8c\u6bd5", new Object[]{flowId, nodeId});
    }

    private Node getNode(Flow flow, String nodeId) {
        if ("end".equals(nodeId)) {
            LOGGER.logMessage(LogLevel.INFO, "\u6d41\u7a0b[flowId:{0},nodeId:{1}]\u4e3a\u7ed3\u675f\u8282\u70b9,\u65e0\u9700\u6267\u884c", new Object[]{flow.getId(), "end"});
            return null;
        }
        if (nodeId == null) {
            nodeId = "begin";
        }
        if ("begin".equals(nodeId) && flow.getNodes().size() == 0) {
            LOGGER.logMessage(LogLevel.INFO, "\u6d41\u7a0b\u65e0\u8282\u70b9,\u6d41\u7a0b[flowId:{0},nodeId:{1}]\u6267\u884c\u5b8c\u6bd5\u3002", new Object[]{flow.getId(), "begin"});
            return null;
        }
        Node node = flow.getNodeMap().get(nodeId);
        if (node == null && "begin".equals(nodeId)) {
            node = flow.getNodes().get(0);
        } else if (node == null) {
            LOGGER.log(LogLevel.ERROR, "flow.flowNodeNotExist", new Object[]{flow.getId(), nodeId});
            throw new FlowRuntimeException(this.i18nMessages.getMessage("flow.flowNodeNotExist", flow.getId(), new Object[]{nodeId}), new Object[0]);
        }
        return node;
    }

    private void logContext(Context context) {
        if (LOGGER.isEnabled(LogLevel.DEBUG)) {
            LOGGER.logMessage(LogLevel.DEBUG, "\u73af\u5883\u5185\u5bb9\u5f00\u59cb\uff1a");
            this.logItemMap(context.getItemMap());
            this.logSubContext(context.getSubContextMap());
            LOGGER.logMessage(LogLevel.DEBUG, "\u73af\u5883\u5185\u5bb9\u7ed3\u675f");
        }
    }

    private void logSubContext(Map<String, Context> subContextMap) {
        LOGGER.logMessage(LogLevel.DEBUG, "\u5b50\u73af\u5883[{0}]\u7684\u5185\u5bb9\u5f00\u59cb\uff1a");
        if (subContextMap != null) {
            for (String key : subContextMap.keySet()) {
                this.logContext(subContextMap.get(key));
            }
        }
        LOGGER.logMessage(LogLevel.DEBUG, "\u5b50\u73af\u5883[{0}]\u7684\u5185\u5bb9\u7ed3\u675f\uff1a");
    }

    private void logItemMap(Map<String, Object> itemMap) {
        for (String key : itemMap.keySet()) {
            LOGGER.logMessage(LogLevel.DEBUG, "key: {0}, value: {1}", new Object[]{key, itemMap.get(key)});
        }
    }

    private static Class<?> getExceptionType(String name) {
        Class<?> exceptionType = exceptionMap.get(name);
        if (exceptionType == null) {
            try {
                exceptionType = Class.forName(name);
                exceptionMap.put(name, exceptionType);
            }
            catch (ClassNotFoundException e) {
                throw new FlowRuntimeException(e);
            }
        }
        return exceptionType;
    }

    private Context getNewContext(Flow flow, Context context) {
        Context flowContext = null;
        if (context == null) {
            return null;
        }
        flowContext = (Context)context.getSubContextMap().get(flow.getId());
        if (flowContext == null) {
            return this.getNewContext(flow, context.getParent());
        }
        return flowContext;
    }

    private void execute(Flow flow, Node node, Context context) {
        String nodeId = node.getId();
        Context flowContext = context;
        try {
            Component component;
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u6267\u884c\u8282\u70b9:{}", new Object[]{nodeId});
            if (flow.isPrivateContext() && (flowContext = this.getNewContext(flow, context)) == null) {
                flowContext = new ContextImpl();
                context.putSubContext(flow.getId(), flowContext);
            }
            if ((component = node.getComponent()) != null) {
                ComponentInterface componentInstance = this.getComponentInstance(component.getName());
                this.setProperties(node, componentInstance, flowContext);
                if (!nodeId.equals("end")) {
                    componentInstance.execute(flowContext);
                }
                LOGGER.logMessage(LogLevel.INFO, "\u8282\u70b9:{}\u6267\u884c\u5b8c\u6bd5", new Object[]{nodeId});
            } else {
                LOGGER.logMessage(LogLevel.INFO, "\u8282\u70b9:{}\u672a\u914d\u7f6e\u7ec4\u4ef6\uff0c\u65e0\u9700\u6267\u884c", new Object[]{nodeId});
            }
        }
        catch (RuntimeException exception) {
            LOGGER.errorMessage("\u6d41\u7a0b\u6267\u884c[flow:{},node:{}]\u53d1\u751f\u5f02\u5e38", (Throwable)exception, new Object[]{flow.getId(), node.getId()});
            if (this.exceptionNodeProcess(flow, node, context, flowContext, exception)) {
                return;
            }
            Node exceptionNode = flow.getNodeMap().get("exception");
            if (exceptionNode != null && this.exceptionNodeProcess(flow, exceptionNode, context, flowContext, exception)) {
                return;
            }
            Flow exceptionProcessFlow = this.getFlow("exceptionProcessFlow");
            if (exceptionProcessFlow != null && (exceptionNode = exceptionProcessFlow.getNodeMap().get("exception")) != null && this.exceptionNodeProcess(exceptionProcessFlow, exceptionNode, context, flowContext, exception)) {
                return;
            }
            throw exception;
        }
        if (nodeId != null && !nodeId.equals("end")) {
            String nextNodeId = node.getNextNodeId(context);
            if (nextNodeId == null) {
                int index = flow.getNodes().indexOf(node);
                nextNodeId = index != flow.getNodes().size() - 1 ? flow.getNodes().get(index + 1).getId() : "end";
            }
            LOGGER.logMessage(LogLevel.INFO, "\u4e0b\u4e00\u8282\u70b9:{}", new Object[]{nextNodeId});
            this.executeNextNode(flow, flowContext, nextNodeId);
        }
    }

    private void checkInputParameter(Flow flow, Context context) {
        StringBuffer buf = new StringBuffer();
        if (flow.getInputParameters() != null) {
            for (Parameter parameter : flow.getInputParameters()) {
                if (!parameter.isRequired()) continue;
                Object value = Context2ObjectUtil.getObject((Parameter)parameter, (Context)context, (ClassLoader)this.getClass().getClassLoader());
                if (value != null) {
                    context.put(parameter.getName(), value);
                    continue;
                }
                if (value != null) continue;
                buf.append("\u53c2\u6570<");
                buf.append(parameter.getName());
                buf.append(">\u5728\u73af\u5883\u4e2d\u4e0d\u5b58\u5728\uff1b");
            }
            if (buf.length() > 0) {
                throw new FlowRuntimeException("flow.inParamNotExist", flow.getId(), buf.toString());
            }
        }
    }

    private void checkOutputParameter(Flow flow, Context context) {
        StringBuffer buf = new StringBuffer();
        if (flow.getOutputParameters() != null) {
            for (Parameter parameter : flow.getOutputParameters()) {
                Object value;
                if (!parameter.isRequired() || (value = context.get(parameter.getName())) != null) continue;
                buf.append("\u53c2\u6570<");
                buf.append(parameter.getName());
                buf.append(">\u5728\u73af\u5883\u4e2d\u4e0d\u5b58\u5728\uff1b");
            }
            if (buf.length() > 0) {
                throw new FlowRuntimeException("flow.outParamNotExist", flow.getId(), buf.toString());
            }
        }
    }

    private boolean exceptionNodeProcess(Flow flow, Node node, Context context, Context newContext, Exception exception) {
        List<String> nextExceptionList = node.getNextExceptionList();
        for (int i = 0; i < nextExceptionList.size(); ++i) {
            String exceptionName = nextExceptionList.get(i);
            if (this.dealException(exception, context, newContext, node, flow, exceptionName)) {
                return true;
            }
            for (Throwable t = exception.getCause(); t != null; t = t.getCause()) {
                if (!this.dealException(t, context, newContext, node, flow, exceptionName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean dealException(Throwable exception, Context context, Context newContext, Node node, Flow flow, String exceptionName) {
        if (FlowExecutorImpl.getExceptionType(exceptionName).isInstance(exception)) {
            String nextNode = node.getNextExceptionNodeMap().get(exceptionName);
            context.put("exceptionProcessFlow", (Object)flow);
            context.put("exceptionNode", (Object)node);
            context.put("throwableObject", (Object)exception);
            this.executeNextNode(flow, newContext, nextNode);
            LOGGER.errorMessage("\u5904\u7406\u6d41\u7a0b\u5f02\u5e38:flow:{},node:{}", exception, new Object[]{flow.getId(), nextNode});
            return true;
        }
        return false;
    }

    private void executeNextNode(Flow flow, Context context, String nextNodeId) {
        String nextExecuteNodeId = nextNodeId;
        int index = nextNodeId.indexOf(58);
        if (index > 0) {
            String[] str = nextNodeId.split(":");
            nextExecuteNodeId = str.length > 1 ? str[1] : "begin";
            this.execute(str[0], nextExecuteNodeId, context);
        } else if (!"end".equals(nextNodeId)) {
            Node nextNode = flow.getNodeMap().get(nextNodeId);
            this.execute(flow, nextNode, context);
        }
    }

    private void setProperties(Node node, ComponentInterface componentInstance, Context context) {
        Map<String, FlowProperty> properties = node.getComponent().getPropertyMap();
        if (properties != null) {
            for (String name : properties.keySet()) {
                FlowProperty property = properties.get(name);
                String value = property.getValue();
                Object object = null;
                object = "el".equals(property.getType()) ? FlowElUtil.execute(value, context, this.getClass().getClassLoader()) : this.getObject(property.getType(), value, context);
                try {
                    PropertyUtils.setProperty((Object)componentInstance, (String)name, (Object)object);
                }
                catch (Exception e) {
                    throw new FlowRuntimeException(e);
                }
            }
        }
    }

    private Object getObject(String type, String value, Context context) {
        String str = value;
        if (str instanceof String) {
            str = formater.format(context, str);
        }
        Object o = null;
        if (str != null) {
            str = str.trim();
            o = StringUtil.isEmpty((String)type) ? SimpleTypeMatcher.matchType((String)str) : ValueUtil.getValue((String)str, (String)type);
        }
        return o;
    }

    @Override
    public void assemble() {
        for (Flow flow : this.flowIdMap.values()) {
            flow.assemble();
        }
    }

    @Override
    public void addFlow(Flow flow) {
        if (flow.getId() != null && this.flowIdMap.get(flow.getId()) != null) {
            LOGGER.logMessage(LogLevel.ERROR, "flow:[id:{0}]\u5df2\u7ecf\u5b58\u5728\uff01", new Object[]{flow.getId()});
        }
        if (flow.getName() != null && this.flowIdMap.get(flow.getName()) != null) {
            LOGGER.logMessage(LogLevel.ERROR, "flow:[name:{0}]\u5df2\u7ecf\u5b58\u5728\uff01", new Object[]{flow.getName()});
        }
        if (flow.getId() != null) {
            LOGGER.logMessage(LogLevel.INFO, "\u6dfb\u52a0flow:[id:{0}]", new Object[]{flow.getId()});
            this.flowIdMap.put(flow.getId(), flow);
        }
        if (flow.getName() != null) {
            LOGGER.logMessage(LogLevel.INFO, "\u6dfb\u52a0flow:[Name:{0}]", new Object[]{flow.getName()});
            this.flowIdMap.put(flow.getName(), flow);
        }
        flow.setFlowExecutor(this);
        this.setChange(true);
    }

    @Override
    public void removeFlow(Flow flow) {
        LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664flow:[id:{0}]", new Object[]{flow.getId()});
        this.flowIdMap.remove(flow.getId());
        LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664flow:[name:{0}]", new Object[]{flow.getName()});
        this.flowIdMap.remove(flow.getName());
        this.setChange(true);
    }

    @Override
    public void removeFlow(String flowId) {
        Flow flow = this.getFlow(flowId);
        this.removeFlow(flow);
    }

    @Override
    public Flow getFlow(String flowId) {
        return this.flowIdMap.get(flowId);
    }

    @Override
    public void addComponents(ComponentDefines components) {
        this.containers.addComponents(components);
    }

    @Override
    public void removeComponents(ComponentDefines components) {
        this.containers.removeComponents(components);
    }

    @Override
    public ComponentInterface getComponentInstance(String componentName) {
        ComponentInterface componentInstance = null;
        if (!StringUtil.isBlank((String)componentName)) {
            componentInstance = this.containers.getComponentInstance(componentName);
            return componentInstance;
        }
        throw new FlowRuntimeException("flow.componentNotExist", componentName);
    }

    @Override
    public Context getInputContext(Flow flow, Context context) {
        return this.getContext(flow.getInputParameters(), context);
    }

    private Context getContext(List<Parameter> parameters, Context context) {
        ContextImpl result = new ContextImpl();
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                result.put(parameter.getName(), context.get(parameter.getName()));
            }
        }
        return result;
    }

    @Override
    public Context getOutputContext(Flow flow, Context context) {
        return this.getContext(flow.getOutputParameters(), context);
    }

    @Override
    public void addComponent(ComponentDefine component) {
        this.containers.addComponent(component);
    }

    @Override
    public void removeComponent(ComponentDefine component) {
        this.containers.removeComponent(component);
    }

    @Override
    public ComponentDefine getComponentDefine(String componentName) {
        return this.containers.getComponentDefine(componentName);
    }

    @Override
    public boolean isChange() {
        return this.change;
    }

    @Override
    public void setChange(boolean change) {
        this.change = change;
    }

    @Override
    public List<ComponentDefine> getComponentDefines() {
        return this.containers.getComponentDefines();
    }

    static {
        formater.addFormatProvider("", (FormatProvider)new ContextFormater());
        formater.addFormatProvider("in", (FormatProvider)new ContextFormater());
        formater.addFormatProvider("out", (FormatProvider)new ContextFormater());
        formater.addFormatProvider("both", (FormatProvider)new ContextFormater());
    }
}

