/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flow.impl;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import org.tinygroup.flow.FlowExecutor;
import org.tinygroup.flow.config.Flow;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;
import org.tinygroup.xstream.XStreamFactory;

public class FlowLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowLoader.class);
    private static final String FLOW_FILE_EXTENSION = ".flow.xml";

    public void load(String path, FlowExecutor executor) {
        LOGGER.logMessage(LogLevel.DEBUG, "\u626b\u63cf\u8def\u5f84{0}\u67e5\u627eFlow\u6587\u4ef6", new Object[]{path});
        FileObject file = VFS.resolveFile((String)path);
        this.load(file, executor);
        LOGGER.logMessage(LogLevel.DEBUG, "\u8def\u5f84{0}\u626b\u63cf\u7ed3\u675f", new Object[]{path});
    }

    private void load(FileObject file, FlowExecutor executor) {
        if (file.isFolder()) {
            this.loadDir(file, executor);
        } else {
            this.loadFile(file, executor);
        }
    }

    private void loadFile(FileObject file, FlowExecutor executor) {
        LOGGER.logMessage(LogLevel.DEBUG, "\u5f00\u59cb\u626b\u63cf\u6587\u4ef6{0}", new Object[]{file.getAbsolutePath()});
        if (file.getFileName().endsWith(FLOW_FILE_EXTENSION)) {
            XStream xStream = XStreamFactory.getXStream((String)"flow");
            Flow flow = null;
            InputStream inputStream = file.getInputStream();
            flow = (Flow)xStream.fromXML(inputStream);
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e, new Object[]{file.getAbsolutePath()});
            }
            executor.addFlow(flow);
            LOGGER.logMessage(LogLevel.DEBUG, "\u6dfb\u52a0Flow[id:{0}]", new Object[]{flow.getId()});
        }
        LOGGER.logMessage(LogLevel.DEBUG, "\u626b\u63cf\u6587\u4ef6{0}\u7ed3\u675f", new Object[]{file.getAbsolutePath()});
    }

    private void loadDir(FileObject file, FlowExecutor executor) {
        LOGGER.logMessage(LogLevel.DEBUG, "\u5f00\u59cb\u626b\u63cf\u76ee\u5f55{0}", new Object[]{file.getAbsolutePath()});
        for (FileObject o : file.getChildren()) {
            this.load(o, executor);
        }
        LOGGER.logMessage(LogLevel.DEBUG, "\u626b\u63cf\u76ee\u5f55{0}\u7ed3\u675f", new Object[]{file.getAbsolutePath()});
    }
}

