/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.pageflow.fileresolver;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.List;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.flow.FlowExecutor;
import org.tinygroup.flow.config.Flow;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFlowRemoveFileProcessor
extends AbstractFileProcessor {
    private static final String PAGE_FLOW_EXT_FILENAME = ".pageflow";
    private FlowExecutor flowExecutor;

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public List<FileObject> getFlowFiles() {
        return this.fileObjects;
    }

    protected boolean checkMatch(FileObject fileObject) {
        return !fileObject.isFolder() && fileObject.getFileName().endsWith(PAGE_FLOW_EXT_FILENAME);
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"flow");
        for (FileObject fileObject : this.fileObjects) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u5220\u9664\u9875\u9762\u6d41\u7a0bpageflow\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            InputStream inputStream = fileObject.getInputStream();
            Flow flow = (Flow)stream.fromXML(inputStream);
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            this.flowExecutor.removeFlow(flow);
            LOGGER.logMessage(LogLevel.INFO, "\u5220\u9664\u52a0\u8f7d\u9875\u9762\u6d41\u7a0bpageflow\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    public void setFileResolver(FileResolver fileResolver) {
    }
}

