/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fulltext;

import java.util.List;

public class Pager<T> {
    private List<T> records;
    private int totalCount;
    private int currentPage;
    private int limit;
    private int start;
    private int totalPages;

    public Pager(int totalCount, int start, List<T> records) {
        this(totalCount, start, 10, records);
    }

    public Pager(int totalCount, int start, int limit, List<T> records) {
        this.records = records;
        this.init(totalCount, start, limit);
    }

    private void init(int totalCount, int start, int limit) {
        this.totalCount = totalCount;
        int nLimit = limit <= 0 ? 10 : limit;
        int nStart = start < 0 ? 0 : start;
        this.limit = nLimit;
        this.start = nStart;
        this.totalPages = totalCount % nLimit == 0 ? totalCount / nLimit : totalCount / nLimit + 1;
        int n = this.currentPage = nStart / nLimit == 0 ? 1 : nStart / nLimit + 1;
        if (this.currentPage > this.totalPages) {
            this.currentPage = this.totalPages;
        }
    }

    public List<T> getRecords() {
        return this.records;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getStart() {
        return this.start;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public String toString() {
        return "Pager [records=" + this.records + ", totalCount=" + this.totalCount + ", currentPage=" + this.currentPage + ", limit=" + this.limit + ", start=" + this.start + ", totalPages=" + this.totalPages + "]";
    }
}

