/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fulltext.document;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.fulltext.FullTextHelper;
import org.tinygroup.fulltext.document.Document;
import org.tinygroup.fulltext.field.Field;
import org.tinygroup.fulltext.field.FieldType;
import org.tinygroup.fulltext.field.HighlightField;

public class HighlightDocument {
    private List<Field> fields = new ArrayList<Field>();

    public HighlightDocument(Document document) {
        this(document, new Object[0]);
    }

    public HighlightDocument(Document document, Object ... arguments) {
        for (Field field : document) {
            if (field instanceof HighlightField) {
                HighlightField f = (HighlightField)field;
                this.fields.add(new FieldWrapper(f, arguments));
                continue;
            }
            this.fields.add(field);
        }
    }

    public String getId() {
        Field f = this.getField(FullTextHelper.getStoreId());
        return f == null ? null : f.getValue().toString();
    }

    public String getType() {
        Field f = this.getField(FullTextHelper.getStoreType());
        return f == null ? null : f.getValue().toString();
    }

    public String getTitle() {
        Field f = this.getField(FullTextHelper.getStoreTitle());
        return f == null ? null : f.getValue().toString();
    }

    public String getAbstract() {
        Field f = this.getField(FullTextHelper.getStoreAbstract());
        return f == null ? null : f.getValue().toString();
    }

    private Field getField(String name) {
        for (Field field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    class FieldWrapper
    implements Field {
        private HighlightField field;
        private Object[] arguments;

        public FieldWrapper(HighlightField hField, Object ... arguments) {
            this.field = hField;
            this.arguments = arguments;
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public FieldType getType() {
            return this.field.getType();
        }

        public Object getValue() {
            if (this.arguments == null || this.arguments.length <= 0) {
                return this.field.getSourceValue();
            }
            return this.field.getRenderValue(this.arguments);
        }
    }
}

