/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fulltext.impl;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.fulltext.DocumentFilter;
import org.tinygroup.fulltext.DocumentListCreator;
import org.tinygroup.fulltext.FullText;
import org.tinygroup.fulltext.IndexOperator;
import org.tinygroup.fulltext.Pager;
import org.tinygroup.fulltext.SearchRule;
import org.tinygroup.fulltext.document.Document;
import org.tinygroup.fulltext.exception.FullTextException;
import org.tinygroup.fulltext.field.Field;

public abstract class AbstractFullText
implements FullText {
    private List<DocumentListCreator> documentListCreators;
    private IndexOperator indexOperator;

    public List<DocumentListCreator> getDocumentListCreators() {
        return this.documentListCreators;
    }

    public void setDocumentListCreators(List<DocumentListCreator> documentListCreators) {
        this.documentListCreators = documentListCreators;
    }

    public IndexOperator getIndexOperator() {
        return this.indexOperator;
    }

    public void setIndexOperator(IndexOperator indexOperator) {
        this.indexOperator = indexOperator;
    }

    protected void checkType(String type) {
        if (StringUtil.isEmpty((String)type)) {
            throw new FullTextException("\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    protected <T> void checkData(T data) {
        if (data == null) {
            throw new FullTextException("\u7d22\u5f15\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    protected <T> boolean matchData(DocumentListCreator creator, T data) {
        try {
            return creator.isMatch(data);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public <T> void createIndex(String type, T data, Object ... arguments) {
        this.checkType(type);
        this.checkData(data);
        for (DocumentListCreator creator : this.documentListCreators) {
            if (!this.matchData(creator, data)) continue;
            List<Document> docs = creator.getDocument(type, data, arguments);
            this.indexOperator.createIndex(docs);
            return;
        }
        throw new FullTextException("\u6ca1\u6709\u627e\u5230\u5408\u9002\u7684\u7d22\u5f15\u5904\u7406\u5668\u521b\u5efa\u7d22\u5f15!");
    }

    @Override
    public <T> void deleteIndex(String type, T data, Object ... arguments) {
        this.checkType(type);
        this.checkData(data);
        for (DocumentListCreator creator : this.documentListCreators) {
            if (!this.matchData(creator, data)) continue;
            List<Document> docs = creator.getDocument(type, data, arguments);
            ArrayList<Field> docIds = new ArrayList<Field>();
            for (Document doc : docs) {
                docIds.add(doc.getId());
            }
            this.indexOperator.deleteIndex(docIds);
            return;
        }
        throw new FullTextException("\u6ca1\u6709\u627e\u5230\u5408\u9002\u7684\u7d22\u5f15\u5904\u7406\u5668\u5220\u9664\u7d22\u5f15!");
    }

    @Override
    public <T> void deleteAllIndexes() {
        this.indexOperator.deleteAllIndexes();
    }

    @Override
    public Pager<Document> search(String searchCondition) {
        return this.search(searchCondition, 0, 10);
    }

    @Override
    public Pager<Document> search(String searchCondition, int start, int limit) {
        return this.search(searchCondition, null, start, limit);
    }

    @Override
    public Pager<Document> search(String searchCondition, DocumentFilter filter, int start, int limit) {
        return this.indexOperator.search(searchCondition, filter, start, limit);
    }

    @Override
    public Pager<Document> search(SearchRule searchRule, int start, int limit) {
        return this.search(searchRule, null, start, limit);
    }

    @Override
    public Pager<Document> search(SearchRule searchRule, DocumentFilter filter, int start, int limit) {
        return this.indexOperator.search(searchRule, filter, start, limit);
    }

    @Override
    public String escape(String queryRule) {
        return queryRule;
    }
}

