/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyioc.impl;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.tinygroup.tinyioc.AopDefine;
import org.tinygroup.tinyioc.BeanContainer;
import org.tinygroup.tinyioc.DynamicProxy;
import org.tinygroup.tinyioc.InterceptorAfter;
import org.tinygroup.tinyioc.InterceptorBefore;
import org.tinygroup.tinyioc.InterceptorException;
import org.tinygroup.tinyioc.TypeConverter;
import org.tinygroup.tinyioc.annotation.Inject;
import org.tinygroup.tinyioc.annotation.Named;
import org.tinygroup.tinyioc.annotation.Prototype;
import org.tinygroup.tinyioc.annotation.Request;
import org.tinygroup.tinyioc.annotation.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanContainerImpl
implements BeanContainer {
    private DynamicProxy proxy = new DynamicProxy();
    private ThreadLocal threadLocal = new ThreadLocal();
    private Map<String, Class> nameMap = new HashMap<String, Class>();
    private Map<Class, String> scopeMap = new HashMap<Class, String>();
    private List<Class> classList = new ArrayList<Class>();
    private Map<Class, Object> objectMap = new HashMap<Class, Object>();
    private Map<Class, TypeConverter> typeConverterMap = new HashMap<Class, TypeConverter>();
    private BeanContainer parent = null;
    private List<BeanContainer> beanContainerList = new ArrayList<BeanContainer>();
    private ClassLoader classLoader;

    public BeanContainerImpl() {
    }

    public BeanContainerImpl(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public <T> void registerClass(Class<T> clazz) {
        Prototype prototype;
        Named named = clazz.getAnnotation(Named.class);
        if (named != null && named.value().length() > 0) {
            this.nameMap.put(named.value(), clazz);
        }
        String scope = "singleton";
        Request request = clazz.getAnnotation(Request.class);
        if (request != null) {
            scope = "request";
        }
        if ((prototype = clazz.getAnnotation(Prototype.class)) != null) {
            scope = "prototype";
        }
        this.classList.add(clazz);
        this.scopeMap.put(clazz, scope);
    }

    @Override
    public <T> T getBeanByName(String name) {
        Class clazz = this.nameMap.get(name);
        if (clazz == null) {
            throw new RuntimeException(String.format("bean with name [%s] not found", name));
        }
        try {
            return this.getBeanByType(clazz);
        }
        catch (RuntimeException e) {
            if (this.parent != null) {
                return this.parent.getBeanByName(name);
            }
            throw e;
        }
    }

    @Override
    public <T> T getBeanByType(String type) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(type);
            return (T)this.getBeanByType(clazz);
        }
        catch (ClassNotFoundException e) {
            if (this.parent != null) {
                return this.parent.getBeanByType(type);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T getBeanByType(Class<T> clazz) {
        T object;
        block5: {
            block3: {
                String scope;
                block6: {
                    block4: {
                        scope = this.scopeMap.get(clazz);
                        object = null;
                        if (scope == null) break block3;
                        if (!"singleton".equalsIgnoreCase(scope)) break block4;
                        object = this.getSingletonObject(clazz);
                        break block5;
                    }
                    if (!"prototype".equalsIgnoreCase(scope)) break block6;
                    object = this.getPrototypeObject(clazz);
                    break block5;
                }
                if (!"request".equalsIgnoreCase(scope)) break block5;
                object = this.getThreadObject(clazz);
                break block5;
            }
            for (Class clz : this.classList) {
                if (!BeanContainerImpl.isSubClass(clz, clazz)) continue;
                object = this.getBeanByType(clz);
            }
        }
        if (object != null) {
            return object;
        }
        if (this.parent != null) {
            return this.parent.getBeanByType(clazz);
        }
        throw new RuntimeException(clazz.getName() + " not found in container.");
    }

    private <T> void buildObject(T object, Class<T> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            Inject inject = field.getAnnotation(Inject.class);
            if (inject == null) continue;
            Named named = field.getAnnotation(Named.class);
            Value valueAnnotation = field.getAnnotation(Value.class);
            if (named == null || named.value().length() > 0) {
                // empty if block
            }
            Object value = null;
            Type fc = field.getGenericType();
            if (fc instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)fc;
                Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                value = this.getCollectionObject(field, genericClazz);
            } else {
                value = valueAnnotation != null && valueAnnotation.value().length() > 0 ? this.getValueObject(field, valueAnnotation.value()) : this.getSingleObject(field, inject, named);
            }
            if (value != null) {
                try {
                    BeanUtils.setProperty(object, (String)field.getName(), (Object)value);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(String.format("\u7c7b%s\u7684\u5c5e\u6027%s\u5bf9\u5e94\u7684Bean\u627e\u4e0d\u5230!", object.getClass().getName(), field.getName()));
        }
    }

    private Object getSingleObject(Field field, Inject inject, Named named) {
        Object value;
        if (named != null && named.value().length() > 0) {
            value = this.getBeanByName(named.value());
        } else {
            value = this.getBeanByType(field.getType());
            if (value == null) {
                value = this.getBeanByName(field.getName());
            }
        }
        return value;
    }

    private Object getValueObject(Field field, String stringValue) {
        TypeConverter converter = this.typeConverterMap.get(field.getType());
        String value = converter != null ? converter.convert(stringValue) : stringValue;
        return value;
    }

    private Object getCollectionObject(Field field, Class clazz) {
        Collection value = null;
        if (field.getType().equals(List.class)) {
            value = this.getBeanList(clazz);
        } else if (field.getType().equals(Set.class)) {
            value = this.getBeanSet(clazz);
        } else if (field.getType().equals(Collection.class)) {
            value = this.getBeanCollection(clazz);
        }
        return value;
    }

    public static boolean isSubClass(Class a, Class b) {
        Type genericSuperclass = a.getGenericSuperclass();
        for (Type type : a.getGenericInterfaces()) {
            if (type.equals(b)) {
                return true;
            }
            boolean is = BeanContainerImpl.isSubClass((Class)type, b);
            if (!is) continue;
            return true;
        }
        if (genericSuperclass != null) {
            if (genericSuperclass.equals(b)) {
                return true;
            }
            boolean is = BeanContainerImpl.isSubClass((Class)genericSuperclass, b);
            if (is) {
                return true;
            }
        }
        return false;
    }

    private <T> T getThreadObject(Class<T> clazz) {
        Object object;
        HashMap threadMap = (HashMap)this.threadLocal.get();
        if (threadMap == null) {
            threadMap = new HashMap();
            this.threadLocal.set(threadMap);
        }
        if ((object = threadMap.get(clazz)) == null) {
            object = this.getPrototypeObject(clazz);
            threadMap.put(clazz, object);
        }
        return (T)object;
    }

    private <T> T getPrototypeObject(Class<T> clazz) {
        try {
            T object = null;
            object = !this.isInterceptorClass(clazz) && this.proxy.isMatchClassName(clazz.getName()) ? (T)this.proxy.getProxyObject(clazz) : (T)clazz.newInstance();
            this.buildObject(object, clazz);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    boolean isInterceptorClass(Class clz) {
        if (BeanContainerImpl.isSubClass(clz, InterceptorAfter.class)) {
            return true;
        }
        if (BeanContainerImpl.isSubClass(clz, InterceptorBefore.class)) {
            return true;
        }
        return BeanContainerImpl.isSubClass(clz, InterceptorException.class);
    }

    private <T> T getSingletonObject(Class<T> clazz) {
        Object object = this.objectMap.get(clazz);
        if (object == null) {
            object = this.getPrototypeObject(clazz);
            this.objectMap.put(clazz, object);
        }
        return (T)object;
    }

    @Override
    public <T> List<T> getBeanList(String type) {
        Class<?> typeClazz = null;
        try {
            typeClazz = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.getBeanList(typeClazz);
    }

    @Override
    public <T> List<T> getBeanList(Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        for (Class clz : this.classList) {
            if (!BeanContainerImpl.isSubClass(clz, clazz)) continue;
            T beanByType = this.getBeanByType(clz);
            list.add(beanByType);
        }
        return list;
    }

    @Override
    public <T> Set<T> getBeanSet(String type) {
        Class<?> typeClazz = null;
        try {
            typeClazz = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.getBeanSet(typeClazz);
    }

    @Override
    public <T> Set<T> getBeanSet(Class<T> clazz) {
        HashSet<T> set = new HashSet<T>();
        for (Class clz : this.classList) {
            if (!BeanContainerImpl.isSubClass(clz, clazz)) continue;
            T beanByType = this.getBeanByType(clz);
            set.add(beanByType);
        }
        return set;
    }

    @Override
    public <T> Collection<T> getBeanCollection(String type) {
        return this.getBeanList(type);
    }

    @Override
    public <T> Collection<T> getBeanCollection(Class<T> clazz) {
        return this.getBeanList(clazz);
    }

    @Override
    public boolean isExistBeanByName(String name) {
        return this.nameMap.containsKey(name);
    }

    @Override
    public boolean isExistBeanByType(String type) {
        try {
            return this.isExistBeanByType(Class.forName(type));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isExistBeanByType(Class clazz) {
        return this.typeConverterMap.containsKey(clazz);
    }

    @Override
    public void addTypeConverter(TypeConverter typeConverter) {
        this.typeConverterMap.put(typeConverter.getType(), typeConverter);
    }

    @Override
    public void addAop(AopDefine aopDefine) {
        this.proxy.addAop(aopDefine);
    }

    @Override
    public void setParent(BeanContainer beanContainer) {
        this.parent = beanContainer;
    }

    @Override
    public void addBeanContainer(BeanContainer beanContainer) {
        if (!this.beanContainerList.contains(beanContainer)) {
            this.beanContainerList.add(beanContainer);
            beanContainer.setParent(this);
        }
    }

    @Override
    public void removeBeanContainer(BeanContainer beanContainer) {
        if (this.beanContainerList.contains(beanContainer)) {
            this.beanContainerList.remove(beanContainer);
            beanContainer.setParent(null);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return this.getClass().getClassLoader();
        }
        return this.classLoader;
    }
}

