/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyioc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.tinygroup.tinyioc.AopDefine;
import org.tinygroup.tinyioc.BeanContainerFactory;
import org.tinygroup.tinyioc.InterceptorAfter;
import org.tinygroup.tinyioc.InterceptorBefore;
import org.tinygroup.tinyioc.InterceptorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicProxy
implements MethodInterceptor {
    List<AopDefine> aopDefineList = new ArrayList<AopDefine>();

    public void addAop(AopDefine aopDefine) {
        this.aopDefineList.add(aopDefine);
    }

    public boolean isMatchClassName(String className) {
        String className2 = className.split("[$][$]")[0];
        for (AopDefine aopDefine : this.aopDefineList) {
            Matcher matcher = aopDefine.getClassPattern().matcher(className2);
            if (!matcher.find() || matcher.group().length() != className2.length()) continue;
            return true;
        }
        return false;
    }

    public <T> T getProxyObject(Class<T> cls) {
        return (T)Enhancer.create(cls, (Callback)this);
    }

    public Object intercept(Object target, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        this.before(target, method, args);
        Object result = null;
        try {
            result = methodProxy.invokeSuper(target, args);
        }
        catch (Exception e) {
            this.exception(target, method, e, args);
            throw e;
        }
        this.after(target, method, args);
        return result;
    }

    private void exception(Object target, Method method, Throwable e, Object[] args) {
        if (!this.isMatchClassName(target.getClass().getName())) {
            return;
        }
        for (AopDefine aopDefine : this.aopDefineList) {
            String exceptionClassName = e.getClass().getName();
            Matcher matcher = aopDefine.getExceptionPattern().matcher(exceptionClassName);
            Object interceptor = BeanContainerFactory.getBeanContainer().getBeanByType(aopDefine.getInterceptorTypeName());
            if (!(interceptor instanceof InterceptorException) || !matcher.find() || matcher.group().length() != exceptionClassName.length()) continue;
            InterceptorException interceptorException = (InterceptorException)interceptor;
            interceptorException.exception(target, method, e, args);
        }
    }

    private void after(Object target, Method method, Object[] args) {
        if (!this.isMatchClassName(target.getClass().getName())) {
            return;
        }
        for (AopDefine aopDefine : this.aopDefineList) {
            String methodName = method.getName();
            Matcher matcher = aopDefine.getMethodPattern().matcher(methodName);
            Object interceptor = BeanContainerFactory.getBeanContainer().getBeanByType(aopDefine.getInterceptorTypeName());
            if (!(interceptor instanceof InterceptorAfter) || !matcher.find() || matcher.group().length() != methodName.length()) continue;
            InterceptorAfter interceptorAfter = (InterceptorAfter)interceptor;
            interceptorAfter.after(target, method, args);
        }
    }

    private void before(Object target, Method method, Object[] args) {
        if (!this.isMatchClassName(target.getClass().getName())) {
            return;
        }
        for (AopDefine aopDefine : this.aopDefineList) {
            String methodName = method.getName();
            Matcher matcher = aopDefine.getMethodPattern().matcher(methodName);
            Object interceptor = BeanContainerFactory.getBeanContainer().getBeanByType(aopDefine.getInterceptorTypeName());
            if (!(interceptor instanceof InterceptorBefore) || !matcher.find() || matcher.group().length() != methodName.length()) continue;
            InterceptorBefore interceptorBefore = (InterceptorBefore)interceptor;
            interceptorBefore.before(target, method, args);
        }
    }
}

