/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.cache.jcs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.control.CompositeCache;
import org.tinygroup.cache.Cache;
import org.tinygroup.cache.CacheManager;

public class JcsCache
implements Cache {
    private JCS jcs;
    private CacheManager cacheManager;

    private void checkSerializable(Object object) {
        if (!(object instanceof Serializable)) {
            throw new RuntimeException("\u5bf9\u8c61\u5fc5\u987b\u5b9e\u73b0Serializable\u63a5\u53e3");
        }
    }

    public Object get(String key) {
        return this.jcs.get((Object)key);
    }

    public void put(String key, Object object) {
        this.checkSerializable(object);
        try {
            this.jcs.put((Object)key, object);
        }
        catch (Exception e) {
            throw new org.tinygroup.cache.exception.CacheException(e);
        }
    }

    public void putSafe(String key, Object object) {
        this.checkSerializable(object);
        try {
            this.jcs.putSafe((Object)key, object);
        }
        catch (Exception e) {
            throw new org.tinygroup.cache.exception.CacheException(e);
        }
    }

    public void put(String groupName, String key, Object object) {
        this.checkSerializable(object);
        try {
            this.jcs.putInGroup((Object)key, groupName, object);
        }
        catch (Exception e) {
            throw new org.tinygroup.cache.exception.CacheException(e);
        }
    }

    public Object get(String groupName, String key) {
        try {
            return this.jcs.getFromGroup((Object)key, groupName);
        }
        catch (Exception e) {
            throw new org.tinygroup.cache.exception.CacheException(e);
        }
    }

    public Set<String> getGroupKeys(String group) {
        return this.jcs.getGroupKeys(group);
    }

    public void cleanGroup(String group) {
        this.jcs.invalidateGroup(group);
    }

    public void clear() {
        try {
            this.jcs.clear();
        }
        catch (Exception e) {
            throw new org.tinygroup.cache.exception.CacheException(e);
        }
    }

    public void remove(String key) {
        try {
            this.jcs.remove((Object)key);
        }
        catch (Exception e) {
            throw new org.tinygroup.cache.exception.CacheException(e);
        }
    }

    public void remove(String group, String key) {
        try {
            this.jcs.remove((Object)key, group);
        }
        catch (Exception e) {
            throw new org.tinygroup.cache.exception.CacheException(e);
        }
    }

    public String getStats() {
        return this.jcs.getStats();
    }

    public int freeMemoryElements(int numberToFree) {
        try {
            return this.jcs.freeMemoryElements(numberToFree);
        }
        catch (CacheException e) {
            throw new org.tinygroup.cache.exception.CacheException((Exception)((Object)e));
        }
    }

    public void init(String region) {
        try {
            this.jcs = JCS.getInstance((String)region);
        }
        catch (Exception e) {
            throw new org.tinygroup.cache.exception.CacheException(e);
        }
    }

    public void destroy() {
        CompositeCache.elementEventQ.destroy();
        this.cacheManager.removeCache((Cache)this);
    }

    public void setCacheManager(CacheManager manager) {
        this.cacheManager = manager;
    }

    public Object[] get(String[] keys) {
        ArrayList<Object> objs = new ArrayList<Object>();
        if (keys != null && keys.length > 0) {
            for (int i = 0; i < keys.length; ++i) {
                objs.add(this.get(keys[i]));
            }
        }
        return objs.toArray();
    }

    public Object[] get(String group, String[] keys) {
        ArrayList<Object> objs = new ArrayList<Object>();
        if (keys != null && keys.length > 0) {
            for (int i = 0; i < keys.length; ++i) {
                objs.add(this.get(group, keys[i]));
            }
        }
        return objs.toArray();
    }

    public void remove(String[] keys) {
        if (keys != null && keys.length > 0) {
            for (int i = 0; i < keys.length; ++i) {
                this.remove(keys[i]);
            }
        }
    }

    public void remove(String group, String[] keys) {
        if (keys != null && keys.length > 0) {
            for (int i = 0; i < keys.length; ++i) {
                this.remove(group, keys[i]);
            }
        }
    }
}

