/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.cache.jcs;

import org.apache.jcs.engine.control.CompositeCacheManager;
import org.tinygroup.cache.AbstractCacheManager;
import org.tinygroup.cache.Cache;
import org.tinygroup.cache.exception.CacheException;
import org.tinygroup.cache.jcs.JcsCache;

public class JcsCacheManager
extends AbstractCacheManager {
    private static JcsCacheManager cacheManager;
    private CompositeCacheManager manager;

    private JcsCacheManager() {
        this(CompositeCacheManager.getInstance());
    }

    private JcsCacheManager(CompositeCacheManager manager) {
        this.manager = manager;
    }

    public static JcsCacheManager getInstance() {
        if (cacheManager == null) {
            cacheManager = new JcsCacheManager();
        }
        return cacheManager;
    }

    public static JcsCacheManager getInstance(CompositeCacheManager manager) {
        if (cacheManager == null) {
            cacheManager = new JcsCacheManager(manager);
        }
        return cacheManager;
    }

    public void shutDown() {
        this.manager.shutDown();
    }

    protected Cache newCache(String region) {
        try {
            JcsCache jcsCache = new JcsCache();
            jcsCache.init(region);
            return jcsCache;
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    protected void internalRemoveCache(Cache cache) {
        this.manager.freeCache((String)this.cacheMap.inverse().get((Object)cache));
    }
}

