/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.cache.jcs.applicationprocessor;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Properties;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.utils.props.PropertyLoader;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.impl.AbstractConfiguration;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.xmlparser.node.XmlNode;

public class JcsCacheProcessor
extends AbstractConfiguration
implements ApplicationProcessor {
    private static final String JCS_CONFIG_PATH = "/application/jcs-config";
    private static final int DEFAULT_REGISTRY_PORT = 1101;
    private static final String DEFAULT_PROPS_FILE_NAME = "cache.ccf";
    private boolean enable = false;

    public void start() {
        String enableString;
        XmlNode combineNode = ConfigurationUtil.combineXmlNode((XmlNode)this.applicationConfig, (XmlNode)this.componentConfig);
        if (combineNode != null && !StringUtil.isBlank((String)(enableString = combineNode.getAttribute("enable")))) {
            this.enable = Boolean.valueOf(enableString);
        }
        if (this.enable) {
            LOGGER.logMessage(LogLevel.INFO, "jcscacheplugin is starting...");
            this.startCluster();
            LOGGER.logMessage(LogLevel.INFO, "jcscacheplugin is started");
        }
    }

    private void startCluster() {
        int registryPort = 1101;
        try {
            Properties props = PropertyLoader.loadProperties((String)DEFAULT_PROPS_FILE_NAME);
            if (props != null) {
                String portS = props.getProperty("registry.port", String.valueOf(1101));
                try {
                    registryPort = Integer.parseInt(portS);
                }
                catch (NumberFormatException e) {
                    LOGGER.errorMessage("Problem converting port to an int.", (Throwable)e, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            LOGGER.errorMessage("Problem loading props.", (Throwable)e, new Object[0]);
        }
        try {
            String registryHost = InetAddress.getLocalHost().getHostAddress();
            LOGGER.logMessage(LogLevel.DEBUG, "registryHost =[{}]", new Object[]{registryHost});
            if ("localhost".equals(registryHost) || "127.0.0.1".equals(registryHost)) {
                LOGGER.logMessage(LogLevel.WARN, "The local address [{}] is INVALID.  Other machines must be able to use the address to reach this server.", new Object[]{registryHost});
            }
            try {
                LocateRegistry.createRegistry(registryPort);
            }
            catch (RemoteException e) {
                LOGGER.errorMessage("Problem creating registry.  It may already be started. {}", (Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Exception t) {
                LOGGER.errorMessage("Problem creating registry.", (Throwable)t, new Object[0]);
            }
            try {
                RemoteCacheServerFactory.startup((String)registryHost, (int)registryPort, (String)"/cache.ccf");
            }
            catch (IOException e) {
                LOGGER.errorMessage("Problem starting remote cache server.", (Throwable)e, new Object[0]);
            }
            catch (Exception t) {
                LOGGER.errorMessage("Problem starting remote cache server.", (Throwable)t, new Object[0]);
            }
        }
        catch (UnknownHostException e) {
            LOGGER.errorMessage("Could not get local address to use for the registry!", (Throwable)e, new Object[0]);
        }
    }

    public void stop() {
        if (this.enable) {
            LOGGER.logMessage(LogLevel.INFO, "Shutting down remote cache ");
            CompositeCacheManager.getInstance().shutDown();
            CompositeCache.elementEventQ.destroy();
            LOGGER.logMessage(LogLevel.INFO, "jcscacheplugin is stopped");
        }
    }

    public String getApplicationNodePath() {
        return JCS_CONFIG_PATH;
    }

    public String getComponentConfigPath() {
        return "/jcscache.config.xml";
    }

    public void setApplication(Application application) {
    }

    public int getOrder() {
        return 0;
    }

    public void init() {
    }
}

