/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jspengine.appserv.server.util;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinygroup.jspengine.appserv.BytecodePreprocessor;
import org.tinygroup.jspengine.common.util.logging.LogDomains;

public class PreprocessorUtil {
    private static boolean _preprocessorEnabled = false;
    private static BytecodePreprocessor[] _preprocessor;

    public static boolean init(String[] ppClassNames) {
        if (ppClassNames != null) {
            PreprocessorUtil.setupPreprocessor(ppClassNames);
        }
        return _preprocessorEnabled;
    }

    public static byte[] processClass(String className, byte[] classBytes) {
        Logger _logger = LogDomains.getLogger("javax.enterprise.system.util.common");
        byte[] goodBytes = classBytes;
        if (_preprocessorEnabled && _preprocessor != null) {
            for (int i = 0; i < _preprocessor.length; ++i) {
                classBytes = _preprocessor[i].preprocess(className, classBytes);
                _logger.fine("[PreprocessorUtil.processClass] Preprocessor " + i + " Processed Class: " + className);
                if (classBytes != null) {
                    goodBytes = classBytes;
                    continue;
                }
                _logger.log(Level.SEVERE, "bytecodepreprocessor.preprocess_failed", new String[]{className, _preprocessor[i].getClass().getName()});
                if (i == 0) {
                    _logger.log(Level.SEVERE, "bytecodepreprocessor.resetting_original", className);
                    continue;
                }
                _logger.log(Level.SEVERE, "bytecodepreprocessor.resetting_last_good", className);
            }
        }
        return goodBytes;
    }

    private static synchronized void setupPreprocessor(String[] ppClassNames) {
        Logger _logger = LogDomains.getLogger("javax.enterprise.system.util.common");
        if (_preprocessor != null) {
            return;
        }
        try {
            _preprocessor = new BytecodePreprocessor[ppClassNames.length];
            for (int i = 0; i < ppClassNames.length; ++i) {
                String ppClassName = ppClassNames[i].trim();
                Class<?> ppClass = Class.forName(ppClassName);
                if (ppClass != null) {
                    PreprocessorUtil._preprocessor[i] = (BytecodePreprocessor)ppClass.newInstance();
                    if (_preprocessor[i] instanceof BytecodePreprocessor) {
                        PreprocessorUtil._preprocessor[i] = _preprocessor[i];
                        _preprocessorEnabled = true;
                    } else {
                        _logger.log(Level.SEVERE, "bytecodepreprocessor.invalid_type", ppClassName);
                        _logger.log(Level.SEVERE, "bytecodepreprocessor.disabled");
                        _preprocessorEnabled = false;
                    }
                }
                if (_preprocessor[i] != null) {
                    if (_preprocessor[i].initialize(new Hashtable())) continue;
                    _logger.log(Level.SEVERE, "bytecodepreprocessor.failed_init", ppClassName);
                    _logger.log(Level.SEVERE, "bytecodepreprocessor.disabled");
                    _preprocessorEnabled = false;
                    continue;
                }
                _logger.log(Level.SEVERE, "bytecodepreprocessor.failed_init", ppClassName);
                _logger.log(Level.SEVERE, "bytecodepreprocessor.disabled");
                _preprocessorEnabled = false;
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "bytecodepreprocessor.setup_ex", t);
            _logger.log(Level.SEVERE, "bytecodepreprocessor.disabled");
            _preprocessorEnabled = false;
            return;
        }
    }

    public static boolean isPreprocessorEnabled() {
        return _preprocessorEnabled;
    }
}

