/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jspengine.compiler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.tagext.FunctionInfo;
import org.tinygroup.jspengine.JasperException;

abstract class ELNode {
    ELNode() {
    }

    public abstract void accept(Visitor var1) throws JasperException;

    public static class Visitor {
        public void visit(Root n) throws JasperException {
            n.getExpression().visit(this);
        }

        public void visit(Function n) throws JasperException {
        }

        public void visit(Text n) throws JasperException {
        }

        public void visit(ELText n) throws JasperException {
        }
    }

    public static class Nodes {
        String mapName = null;
        private List list = new ArrayList();

        public void add(ELNode en) {
            this.list.add(en);
        }

        public void visit(Visitor v) throws JasperException {
            for (ELNode n : this.list) {
                n.accept(v);
            }
        }

        public Iterator iterator() {
            return this.list.iterator();
        }

        public boolean isEmpty() {
            return this.list.size() == 0;
        }

        public boolean containsEL() {
            for (ELNode n : this.list) {
                if (!(n instanceof Root)) continue;
                return true;
            }
            return false;
        }

        public boolean hasDollarExpression() {
            for (ELNode n : this.list) {
                if (!(n instanceof Root) || !((Root)n).isDollarExpr) continue;
                return true;
            }
            return false;
        }

        public boolean hasPoundExpression() {
            for (ELNode n : this.list) {
                if (!(n instanceof Root) || ((Root)n).isDollarExpr) continue;
                return true;
            }
            return false;
        }

        public String getMapName() {
            return this.mapName;
        }

        public void setMapName(String name) {
            this.mapName = name;
        }
    }

    public static class Function
    extends ELNode {
        private String prefix;
        private String name;
        private String uri;
        private FunctionInfo functionInfo;
        private String methodName;
        private String[] parameters;

        Function(String prefix, String name) {
            this.prefix = prefix;
            this.name = name;
        }

        @Override
        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public FunctionInfo getFunctionInfo() {
            return this.functionInfo;
        }

        public void setFunctionInfo(FunctionInfo f) {
            this.functionInfo = f;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String[] getParameters() {
            return this.parameters;
        }

        public void setParameters(String[] parameters) {
            this.parameters = parameters;
        }
    }

    public static class ELText
    extends ELNode {
        private String text;

        ELText(String text) {
            this.text = text;
        }

        @Override
        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Text
    extends ELNode {
        private String text;

        Text(String text) {
            this.text = text;
        }

        @Override
        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Root
    extends ELNode {
        private Nodes expr;
        private boolean isDollarExpr;

        Root(Nodes expr, boolean isDollarExpr) {
            this.expr = expr;
            this.isDollarExpr = isDollarExpr;
        }

        @Override
        public void accept(Visitor v) throws JasperException {
            v.visit(this);
        }

        public Nodes getExpression() {
            return this.expr;
        }
    }
}

