/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jspengine.fileresolver;

import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.jspengine.fileresolver.TldFileManager;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;

public class TldFileProcessor
extends AbstractFileProcessor {
    private static final String TLD_FILE_EXT_NAME = ".tld";

    public void process() {
        TldFileManager manager = TldFileManager.getInstance();
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664tld\u6587\u4ef6\uff1a<{}>", new Object[]{fileObject.getAbsolutePath()});
            manager.removeTldFile(fileObject);
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664tld\u6587\u4ef6\uff1a<{}>\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dtld\u6587\u4ef6\uff1a<{}>", new Object[]{fileObject.getAbsolutePath()});
            manager.addTldFile(fileObject);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dtld\u6587\u4ef6\uff1a<{}>\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(TLD_FILE_EXT_NAME);
    }
}

