/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jspengine.compiler;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.tinygroup.jspengine.JspCompilationContext;
import org.tinygroup.jspengine.Options;
import org.tinygroup.jspengine.compiler.AntJavaCompiler;
import org.tinygroup.jspengine.compiler.BeanRepository;
import org.tinygroup.jspengine.compiler.Collector;
import org.tinygroup.jspengine.compiler.ELFunctionMapper;
import org.tinygroup.jspengine.compiler.ErrorDispatcher;
import org.tinygroup.jspengine.compiler.Generator;
import org.tinygroup.jspengine.compiler.JDTJavaCompiler;
import org.tinygroup.jspengine.compiler.JavaCompiler;
import org.tinygroup.jspengine.compiler.JavacErrorDetail;
import org.tinygroup.jspengine.compiler.JspConfig;
import org.tinygroup.jspengine.compiler.JspProperty;
import org.tinygroup.jspengine.compiler.JspRuntimeContext;
import org.tinygroup.jspengine.compiler.JspUtil;
import org.tinygroup.jspengine.compiler.Node;
import org.tinygroup.jspengine.compiler.PageInfo;
import org.tinygroup.jspengine.compiler.ParserController;
import org.tinygroup.jspengine.compiler.ScriptingVariabler;
import org.tinygroup.jspengine.compiler.ServletWriter;
import org.tinygroup.jspengine.compiler.SmapUtil;
import org.tinygroup.jspengine.compiler.TagFileProcessor;
import org.tinygroup.jspengine.compiler.TagPluginManager;
import org.tinygroup.jspengine.compiler.TextOptimizer;
import org.tinygroup.jspengine.compiler.Validator;
import org.tinygroup.jspengine.org.apache.commons.logging.Log;
import org.tinygroup.jspengine.org.apache.commons.logging.LogFactory;
import org.tinygroup.jspengine.org.apache.commons.logging.impl.NoOpLog;
import org.tinygroup.jspengine.servlet.JspServletWrapper;

public class Compiler {
    private static Log commonsLog = LogFactory.getLog(Compiler.class);
    private static Log noOpLog = new NoOpLog();
    protected JspCompilationContext ctxt;
    private ErrorDispatcher errDispatcher;
    private PageInfo pageInfo;
    private JspServletWrapper jsw;
    private TagFileProcessor tfp;
    private JavaCompiler javaCompiler;
    private boolean jspcMode;
    private Log log;
    private SmapUtil smapUtil;
    private Options options;
    private Node.Nodes pageNodes;
    private long jspModTime;

    public Compiler(JspCompilationContext ctxt, JspServletWrapper jsw) {
        this.jsw = jsw;
        this.ctxt = ctxt;
        this.jspcMode = false;
        this.options = ctxt.getOptions();
        this.log = commonsLog;
        this.smapUtil = new SmapUtil(ctxt);
        this.errDispatcher = new ErrorDispatcher(this.jspcMode);
        this.javaCompiler = new AntJavaCompiler();
        this.javaCompiler.init(ctxt, this.errDispatcher, this.jspcMode);
    }

    public Compiler(JspCompilationContext ctxt, JspServletWrapper jsw, boolean jspcMode) {
        this.jsw = jsw;
        this.ctxt = ctxt;
        this.jspcMode = jspcMode;
        this.options = ctxt.getOptions();
        this.log = jspcMode ? noOpLog : commonsLog;
        this.smapUtil = new SmapUtil(ctxt);
        this.errDispatcher = new ErrorDispatcher(jspcMode);
        this.initJavaCompiler();
    }

    private void generateJava() throws Exception {
        long t4 = 0L;
        long t3 = 0L;
        long t2 = 0L;
        long t1 = 0L;
        if (this.log.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        this.pageInfo = new PageInfo(new BeanRepository(this.ctxt.getClassLoader(), this.errDispatcher), this.ctxt.getJspFile());
        JspConfig jspConfig = this.options.getJspConfig();
        JspProperty jspProperty = jspConfig.findJspProperty(this.ctxt.getJspFile());
        this.pageInfo.setELIgnored(JspUtil.booleanValue(jspProperty.isELIgnored()));
        this.pageInfo.setScriptingInvalid(JspUtil.booleanValue(jspProperty.isScriptingInvalid()));
        this.pageInfo.setTrimDirectiveWhitespaces(JspUtil.booleanValue(jspProperty.getTrimSpaces()));
        this.pageInfo.setDeferredSyntaxAllowedAsLiteral(JspUtil.booleanValue(jspProperty.getPoundAllowed()));
        if (jspProperty.getIncludePrelude() != null) {
            this.pageInfo.setIncludePrelude(jspProperty.getIncludePrelude());
        }
        if (jspProperty.getIncludeCoda() != null) {
            this.pageInfo.setIncludeCoda(jspProperty.getIncludeCoda());
        }
        if (this.options.isDefaultBufferNone() && this.pageInfo.getBufferValue() == null) {
            this.pageInfo.setBuffer(0);
        }
        String javaFileName = this.ctxt.getServletJavaFileName();
        ServletWriter writer = null;
        try {
            Writer javaWriter = this.javaCompiler.getJavaWriter(javaFileName, this.ctxt.getOptions().getJavaEncoding());
            writer = new ServletWriter(new PrintWriter(javaWriter));
            this.ctxt.setWriter(writer);
            JspUtil.resetTemporaryVariableName();
            ParserController parserCtl = new ParserController(this.ctxt, this);
            this.pageNodes = parserCtl.parse(this.ctxt.getJspFile());
            if (this.ctxt.isPrototypeMode()) {
                Generator.generate(writer, this, this.pageNodes);
                writer.close();
                writer = null;
                return;
            }
            Validator.validate(this, this.pageNodes);
            if (this.log.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
            }
            Collector.collect(this, this.pageNodes);
            this.tfp = new TagFileProcessor();
            this.tfp.loadTagFiles(this, this.pageNodes);
            if (this.log.isDebugEnabled()) {
                t3 = System.currentTimeMillis();
            }
            ScriptingVariabler.set(this.pageNodes, this.errDispatcher);
            TagPluginManager tagPluginManager = this.options.getTagPluginManager();
            tagPluginManager.apply(this.pageNodes, this.errDispatcher, this.pageInfo);
            TextOptimizer.concatenate(this, this.pageNodes);
            ELFunctionMapper.map(this, this.pageNodes);
            Generator.generate(writer, this, this.pageNodes);
            writer.close();
            writer = null;
            this.ctxt.setWriter(null);
            if (this.log.isDebugEnabled()) {
                t4 = System.currentTimeMillis();
                this.log.debug("Generated " + javaFileName + " total=" + (t4 - t1) + " generate=" + (t4 - t3) + " validate=" + (t2 - t1));
            }
        }
        catch (Exception e) {
            if (writer != null) {
                try {
                    writer.close();
                    writer = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.javaCompiler.doJavaFile(false);
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!this.options.isSmapSuppressed()) {
            this.smapUtil.generateSmap(this.pageNodes);
        }
        this.tfp.removeProtoTypeFiles(this.ctxt.getClassFileName());
    }

    private void addClassPath(String classPath, ArrayList<File> cpath, HashSet<String> paths) {
        if (classPath == null) {
            return;
        }
        String sep = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classPath, sep);
        while (tokenizer.hasMoreElements()) {
            String path = tokenizer.nextToken();
            if (paths.contains(path)) continue;
            paths.add(path);
            cpath.add(new File(path));
        }
    }

    private void generateClass() throws Exception {
        JavacErrorDetail[] javacErrors;
        String sep;
        long t1 = 0L;
        if (this.log.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        String javaFileName = this.ctxt.getServletJavaFileName();
        String classpath = this.ctxt.getClassPath();
        String sysClassPath = this.options.getSystemClassPath();
        ArrayList<File> cpath = new ArrayList<File>();
        HashSet<String> paths = new HashSet<String>();
        if (this.options.isDelegate()) {
            this.addClassPath(sysClassPath, cpath, paths);
            this.addClassPath(classpath, cpath, paths);
            if (this.log.isDebugEnabled()) {
                sep = System.getProperty("path.separator");
                this.log.debug("Using classpath: " + sysClassPath + sep + classpath);
            }
        } else {
            this.addClassPath(classpath, cpath, paths);
            this.addClassPath(sysClassPath, cpath, paths);
            if (this.log.isDebugEnabled()) {
                sep = System.getProperty("path.separator");
                this.log.debug("Using classpath: " + classpath + sep + sysClassPath);
            }
        }
        this.javaCompiler.setClassPath(cpath);
        this.javaCompiler.setDebug(this.options.getClassDebugInfo());
        String exts = System.getProperty("java.ext.dirs");
        if (exts != null) {
            this.javaCompiler.setExtdirs(exts);
        }
        if (this.options.getCompilerTargetVM() != null) {
            this.javaCompiler.setTargetVM(this.options.getCompilerTargetVM());
        }
        if (this.options.getCompilerSourceVM() != null) {
            this.javaCompiler.setSourceVM(this.options.getCompilerSourceVM());
        }
        if ((javacErrors = this.javaCompiler.compile(this.ctxt.getFullClassName(), this.pageNodes)) != null) {
            this.javaCompiler.doJavaFile(true);
            this.log.error("Error compiling file: " + javaFileName);
            this.errDispatcher.javacError(javacErrors);
        }
        if (this.log.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            this.log.debug("Compiled " + javaFileName + " " + (t2 - t1) + "ms");
        }
        this.javaCompiler.doJavaFile(this.ctxt.keepGenerated());
        if (!this.ctxt.isPrototypeMode() && !this.options.isSmapSuppressed()) {
            this.smapUtil.installSmap();
        }
        if (this.jsw != null && this.jsw.getServletClassLastModifiedTime() <= 0L) {
            this.jsw.setServletClassLastModifiedTime(this.javaCompiler.getClassLastModified());
        }
        if (this.options.getSaveBytecode()) {
            this.javaCompiler.saveClassFile(this.ctxt.getFullClassName(), this.ctxt.getClassFileName());
        }
        this.ctxt.getRuntimeContext().adjustBytecodeTime(this.ctxt.getFullClassName(), this.jspModTime);
    }

    public void compile(boolean compileClass) throws Exception {
        try {
            this.ctxt.getOutputDir();
            this.ctxt.makeOutputDir();
            if (this.errDispatcher == null) {
                this.errDispatcher = new ErrorDispatcher(this.jspcMode);
            }
            this.generateJava();
            if (compileClass) {
                this.generateClass();
            } else {
                this.javaCompiler.doJavaFile(this.ctxt.keepGenerated());
            }
        }
        finally {
            if (this.tfp != null) {
                this.tfp.removeProtoTypeFiles(null);
            }
            this.tfp = null;
            this.errDispatcher = null;
            if (!this.jspcMode) {
                this.pageInfo = null;
            }
            this.pageNodes = null;
            if (this.ctxt.getWriter() != null) {
                this.ctxt.getWriter().close();
                this.ctxt.setWriter(null);
            }
        }
    }

    public boolean isOutDated() {
        return this.isOutDated(true);
    }

    public boolean isOutDated(boolean checkClass) {
        File jspFile;
        String jsp = this.ctxt.getJspFile();
        if (this.jsw != null && this.ctxt.getOptions().getModificationTestInterval() > 0) {
            if (this.jsw.getLastModificationTest() + (long)(this.ctxt.getOptions().getModificationTestInterval() * 1000) > System.currentTimeMillis()) {
                return false;
            }
            this.jsw.setLastModificationTest(System.currentTimeMillis());
        }
        long jspRealLastModified = 0L;
        File targetFile = checkClass ? new File(this.ctxt.getClassFileName()) : new File(this.ctxt.getServletJavaFileName());
        long targetLastModified = targetFile.lastModified();
        if (checkClass) {
            String className;
            JspRuntimeContext rtctxt = this.ctxt.getRuntimeContext();
            long cachedTime = rtctxt.getBytecodeBirthTime(className = this.ctxt.getFullClassName());
            if (cachedTime > targetLastModified) {
                targetLastModified = cachedTime;
            } else {
                rtctxt.setBytecode(className, null);
            }
        }
        if (targetLastModified == 0L) {
            return true;
        }
        if (this.jsw != null && (jspFile = this.jsw.getJspFile()) != null) {
            jspRealLastModified = jspFile.lastModified();
        }
        if (jspRealLastModified == 0L || targetLastModified < jspRealLastModified) {
            try {
                URL jspUrl = this.ctxt.getResource(jsp);
                if (jspUrl == null) {
                    this.ctxt.incrementRemoved();
                    return false;
                }
                URLConnection uc = jspUrl.openConnection();
                jspRealLastModified = uc.getLastModified();
                uc.getInputStream().close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        if (checkClass && this.jsw != null) {
            this.jsw.setServletClassLastModifiedTime(targetLastModified);
        }
        if (targetLastModified < jspRealLastModified) {
            this.jspModTime = jspRealLastModified;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Compiler: outdated: " + targetFile + " " + targetLastModified);
            }
            return true;
        }
        if (this.jsw == null) {
            return false;
        }
        List depends = this.jsw.getDependants();
        if (depends == null) {
            return false;
        }
        for (String include : depends) {
            try {
                URL includeUrl = this.ctxt.getResource(include);
                if (includeUrl == null) {
                    return true;
                }
                URLConnection includeUconn = includeUrl.openConnection();
                long includeLastModified = includeUconn.getLastModified();
                includeUconn.getInputStream().close();
                if (includeLastModified <= targetLastModified) continue;
                if (include.endsWith(".tld")) {
                    this.ctxt.clearTaglibs();
                    this.ctxt.clearTagFileJarUrls();
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        return false;
    }

    public ErrorDispatcher getErrorDispatcher() {
        return this.errDispatcher;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public JspCompilationContext getCompilationContext() {
        return this.ctxt;
    }

    public void removeGeneratedFiles() {
        try {
            String classFileName = this.ctxt.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Deleting " + classFile);
                }
                classFile.delete();
            }
        }
        catch (Exception classFileName) {
            // empty catch block
        }
        try {
            String javaFileName = this.ctxt.getServletJavaFileName();
            if (javaFileName != null) {
                File javaFile = new File(javaFileName);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Deleting " + javaFile);
                }
                javaFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeGeneratedClassFiles() {
        try {
            String classFileName = this.ctxt.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Deleting " + classFile);
                }
                classFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initJavaCompiler() {
        Class<JDTJavaCompiler> c = this.getClassFor("javax.tools.ToolProvider");
        if (c != null && (c = this.getClassFor("org.apache.jasper.compiler.Jsr199JavaCompiler")) != null) {
            try {
                this.javaCompiler = (JavaCompiler)c.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.javaCompiler == null && (c = this.getClassFor("org.eclipse.jdt.internal.compiler.Compiler")) != null && (c = JDTJavaCompiler.class) != null) {
            try {
                this.javaCompiler = (JavaCompiler)c.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.javaCompiler == null) {
            this.javaCompiler = new AntJavaCompiler();
        }
        this.javaCompiler.init(this.ctxt, this.errDispatcher, this.jspcMode);
    }

    private Class getClassFor(String className) {
        Class<?> c = null;
        try {
            c = Class.forName(className, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return c;
    }
}

