/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jspengine.compiler;

import org.tinygroup.jspengine.JasperException;
import org.tinygroup.jspengine.Options;
import org.tinygroup.jspengine.compiler.Compiler;
import org.tinygroup.jspengine.compiler.Node;
import org.tinygroup.jspengine.compiler.PageInfo;

public class TextOptimizer {
    public static void concatenate(Compiler compiler, Node.Nodes page) throws JasperException {
        TextCatVisitor v;
        boolean trim;
        Options options = compiler.getCompilationContext().getOptions();
        PageInfo pageInfo = compiler.getPageInfo();
        boolean bl = trim = options.getTrimSpaces() || pageInfo.isTrimDirectiveWhitespaces();
        if (trim) {
            v = new TextCatVisitor(true, trim);
            page.visit(v);
            v.collectText();
        }
        v = new TextCatVisitor(false, trim);
        page.visit(v);
        v.collectText();
    }

    static class TextCatVisitor
    extends Node.Visitor {
        private final String emptyText = new String("");
        private int textNodeCount = 0;
        private Node.TemplateText firstTextNode = null;
        private StringBuffer textBuffer;
        private boolean prePass;
        private boolean trim;

        public TextCatVisitor(boolean prePass, boolean trim) {
            this.prePass = prePass;
            this.trim = trim;
        }

        @Override
        public void doVisit(Node n) throws JasperException {
            this.collectText();
        }

        @Override
        public void visit(Node.PageDirective n) throws JasperException {
            if (this.prePass) {
                this.collectText();
            }
        }

        @Override
        public void visit(Node.TagDirective n) throws JasperException {
            if (this.prePass) {
                this.collectText();
            }
        }

        @Override
        public void visit(Node.TaglibDirective n) throws JasperException {
            if (this.prePass) {
                this.collectText();
            }
        }

        @Override
        public void visit(Node.AttributeDirective n) throws JasperException {
            if (this.prePass) {
                this.collectText();
            }
        }

        @Override
        public void visit(Node.VariableDirective n) throws JasperException {
            if (this.prePass) {
                this.collectText();
            }
        }

        @Override
        public void visitBody(Node n) throws JasperException {
            super.visitBody(n);
            this.collectText();
        }

        @Override
        public void visit(Node.TemplateText n) throws JasperException {
            if (this.trim && !this.prePass && n.isAllSpace()) {
                n.setText(this.emptyText);
                return;
            }
            if (this.textNodeCount++ == 0) {
                this.firstTextNode = n;
                this.textBuffer = new StringBuffer(n.getText());
            } else {
                this.textBuffer.append(n.getText());
                n.setText(this.emptyText);
            }
        }

        private void collectText() {
            if (this.textNodeCount > 1) {
                this.firstTextNode.setText(this.textBuffer.toString());
            }
            this.textNodeCount = 0;
        }
    }
}

