/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jspengine.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Date;

public class FastDateFormat
extends DateFormat {
    private DateFormat df;
    private long lastSec = -1L;
    private StringBuffer sb = new StringBuffer();
    private FieldPosition fp = new FieldPosition(8);

    public FastDateFormat(DateFormat df) {
        this.df = df;
    }

    @Override
    public Date parse(String text, ParsePosition pos) {
        return this.df.parse(text, pos);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        long dt = date.getTime();
        long ds = dt / 1000L;
        if (ds != this.lastSec) {
            this.sb.setLength(0);
            this.df.format(date, this.sb, this.fp);
            this.lastSec = ds;
        } else {
            int ms = (int)(dt % 1000L);
            int pos = this.fp.getEndIndex();
            int begin = this.fp.getBeginIndex();
            if (pos > 0) {
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
                ms /= 10;
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
                ms /= 10;
                if (pos > begin) {
                    this.sb.setCharAt(--pos, Character.forDigit(ms % 10, 10));
                }
            }
        }
        toAppendTo.append(this.sb.toString());
        return toAppendTo;
    }
}

